/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.core.manipulation.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.OccurrencesSearchQuery;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;

public final class FindOccurrencesEngine {
    private IOccurrencesFinder fFinder;

    public static FindOccurrencesEngine create(IOccurrencesFinder finder) {
        return new FindOccurrencesEngine(finder);
    }

    private FindOccurrencesEngine(IOccurrencesFinder finder) {
        if (finder == null) {
            throw new IllegalArgumentException();
        }
        this.fFinder = finder;
    }

    private String run(CompilationUnit astRoot, int offset, int length) {
        String message = this.fFinder.initialize(astRoot, offset, length);
        if (message != null) {
            return message;
        }
        this.performNewSearch(this.fFinder, astRoot.getTypeRoot());
        return null;
    }

    public String run(ITypeRoot input, int offset, int length) throws JavaModelException {
        if (input.getSourceRange() == null) {
            return SearchMessages.FindOccurrencesEngine_noSource_text;
        }
        CompilationUnit root = SharedASTProvider.getAST(input, SharedASTProvider.WAIT_YES, null);
        if (root == null) {
            return SearchMessages.FindOccurrencesEngine_cannotParse_text;
        }
        return this.run(root, offset, length);
    }

    private void performNewSearch(IOccurrencesFinder finder, ITypeRoot element) {
        NewSearchUI.runQueryInBackground((ISearchQuery)new OccurrencesSearchQuery(finder, element));
    }
}

