/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditorMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PatternConstructor;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class PropertyKeyHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private String fPropertiesKey;
    private Shell fShell;
    private IStorage fStorage;
    private ITextEditor fEditor;
    private boolean fIsFileEditorInput;

    public PropertyKeyHyperlink(IRegion region, String key, ITextEditor editor) {
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)key);
        Assert.isNotNull((Object)editor);
        this.fRegion = region;
        this.fPropertiesKey = key;
        this.fEditor = editor;
        this.fIsFileEditorInput = this.fEditor.getEditorInput() instanceof IFileEditorInput;
        IStorageEditorInput storageEditorInput = (IStorageEditorInput)this.fEditor.getEditorInput();
        this.fShell = this.fEditor.getEditorSite().getShell();
        try {
            this.fStorage = storageEditorInput.getStorage();
        }
        catch (CoreException coreException) {
            this.fStorage = null;
        }
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        KeyReference[] references = this.search(this.fPropertiesKey);
        if (references == null) {
            return;
        }
        if (references.length == 0) {
            String message = PropertiesFileEditorMessages.OpenAction_error_messageNoResult;
            this.showErrorInStatusLine(message);
            return;
        }
        this.open(references);
    }

    private void open(KeyReference[] keyReferences) {
        Assert.isLegal((keyReferences != null && keyReferences.length > 0 ? 1 : 0) != 0);
        if (keyReferences.length == 1) {
            this.open(keyReferences[0]);
        } else {
            this.open(this.select(keyReferences));
        }
    }

    private KeyReference select(final KeyReference[] keyReferences) {
        Object[] result;
        Arrays.sort(keyReferences);
        final int length = keyReferences.length;
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider(){

            public String decorateText(String input, Object element) {
                String name;
                KeyReference keyRef = (KeyReference)element;
                IJavaElement javaElement = keyRef.element;
                IResource resource = keyRef.resource;
                String string = name = javaElement != null ? JavaElementLabels.getElementLabel(javaElement, JavaElementLabels.ALL_DEFAULT | JavaElementLabels.ALL_FULLY_QUALIFIED | 0x1000000000000L | 0x2000000000L) : resource.getName();
                if (name == null) {
                    return input;
                }
                int count = 0;
                int i = 0;
                while (i < length) {
                    if (javaElement != null) {
                        if (keyReferences[i].element.equals(javaElement)) {
                            ++count;
                        }
                    } else if (keyReferences[i].resource.equals((Object)resource)) {
                        ++count;
                    }
                    ++i;
                }
                if (count > 1) {
                    Object[] args = new Object[]{BasicElementLabels.getResourceName((String)name), new Integer(count)};
                    name = Messages.format(PropertiesFileEditorMessages.OpenAction_SelectionDialog_elementLabelWithMatchCount, args);
                }
                return name;
            }

            protected ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
                KeyReference keyRef = (KeyReference)element;
                IJavaElement javaElement = keyRef.element;
                return javaElement != null ? new JavaElementImageProvider().getJavaImageDescriptor(javaElement, 2) : super.decorateImage(input, element);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.fShell, (ILabelProvider)labelProvider, (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setLowerListLabel(PropertiesFileEditorMessages.OpenAction_SelectionDialog_details);
        dialog.setLowerListComparator((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return 0;
            }
        });
        dialog.setTitle(PropertiesFileEditorMessages.OpenAction_SelectionDialog_title);
        dialog.setMessage(PropertiesFileEditorMessages.OpenAction_SelectionDialog_message);
        dialog.setElements((Object[])keyReferences);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
            return (KeyReference)result[0];
        }
        return null;
    }

    private void open(KeyReference keyReference) {
        if (keyReference == null) {
            return;
        }
        try {
            IEditorPart part;
            IEditorPart iEditorPart = part = keyReference.element != null ? EditorUtility.openInEditor(keyReference.element, true) : EditorUtility.openInEditor(keyReference.resource, true);
            if (part != null) {
                EditorUtility.revealInEditor(part, keyReference.offset, keyReference.length);
            }
        }
        catch (PartInitException x) {
            String message = null;
            IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)keyReference.getAdapter(IWorkbenchAdapter.class);
            if (wbAdapter != null) {
                message = Messages.format(PropertiesFileEditorMessages.OpenAction_error_messageArgs, new String[]{wbAdapter.getLabel((Object)keyReference), x.getLocalizedMessage()});
            }
            if (message == null) {
                message = Messages.format(PropertiesFileEditorMessages.OpenAction_error_message, x.getLocalizedMessage());
            }
            MessageDialog.openError((Shell)this.fShell, (String)PropertiesFileEditorMessages.OpenAction_error_messageProblems, (String)message);
        }
    }

    private String getErrorDialogTitle() {
        return PropertiesFileEditorMessages.OpenAction_error_title;
    }

    private void showError(CoreException e) {
        ExceptionHandler.handle(e, this.fShell, this.getErrorDialogTitle(), PropertiesFileEditorMessages.OpenAction_error_message);
    }

    private void showErrorInStatusLine(final String message) {
        this.fShell.getDisplay().beep();
        final IEditorStatusLine statusLine = (IEditorStatusLine)this.fEditor.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            this.fShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    statusLine.setMessage(true, message, null);
                }
            });
        }
    }

    private boolean useDoubleQuotedKey() {
        if (this.fStorage == null) {
            return false;
        }
        String name = this.fStorage.getName();
        return name != null && !"about.properties".equals(name) && !"feature.properties".equals(name) && !"plugin.properties".equals(name);
    }

    private KeyReference[] search(final String key) {
        if (key == null) {
            return new KeyReference[0];
        }
        final ArrayList result = new ArrayList(5);
        try {
            this.fEditor.getEditorSite().getWorkbenchWindow().getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("", 5);
                    try {
                        boolean useDoubleQuotedKey = PropertyKeyHyperlink.this.useDoubleQuotedKey();
                        if (useDoubleQuotedKey) {
                            SearchPattern pattern = SearchPattern.createPattern((String)key, (int)4, (int)2, (int)10);
                            if (pattern == null) {
                                return;
                            }
                            try {
                                new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), SearchEngine.createWorkspaceScope(), new SearchRequestor(){

                                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                                        IResource resource = match.getResource();
                                        if (resource != null) {
                                            result.add(new KeyReference(resource, (IJavaElement)match.getElement(), match.getOffset(), match.getLength(), PropertyKeyHyperlink.this.fIsFileEditorInput));
                                        }
                                    }
                                }, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        if (result.size() == 0) {
                            String searchString;
                            if (useDoubleQuotedKey) {
                                StringBuffer buf = new StringBuffer("\"");
                                buf.append(key);
                                buf.append('\"');
                                searchString = buf.toString();
                            } else {
                                searchString = key;
                            }
                            ResultCollector collector = new ResultCollector(result, useDoubleQuotedKey);
                            TextSearchEngine engine = TextSearchEngine.create();
                            Pattern searchPattern = PatternConstructor.createPattern(searchString, true, false);
                            if (PropertyKeyHyperlink.this.fStorage instanceof IResource) {
                                engine.search(PropertyKeyHyperlink.createScope((IResource)((IResource)PropertyKeyHyperlink.this.fStorage).getProject()), (TextSearchRequestor)collector, searchPattern, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                            }
                        } else {
                            monitor.worked(1);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException ex) {
            String message = PropertiesFileEditorMessages.OpenAction_error_messageErrorSearchingKey;
            this.showError(new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 0, message, ex.getTargetException())));
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return result.toArray(new KeyReference[result.size()]);
    }

    private static TextSearchScope createScope(IResource scope) {
        ArrayList<String> fileNamePatternStrings = new ArrayList<String>();
        String[] javaExtensions = JavaCore.getJavaLikeExtensions();
        int i = 0;
        while (i < javaExtensions.length) {
            fileNamePatternStrings.add("*." + javaExtensions[i]);
            ++i;
        }
        fileNamePatternStrings.add("*.xml");
        fileNamePatternStrings.add("*.ini");
        String[] allPatternStrings = fileNamePatternStrings.toArray(new String[fileNamePatternStrings.size()]);
        Pattern fileNamePattern = PatternConstructor.createPattern(allPatternStrings, false, false);
        return TextSearchScope.newSearchScope((IResource[])new IResource[]{scope}, (Pattern)fileNamePattern, (boolean)false);
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return Messages.format(PropertiesFileEditorMessages.OpenAction_hyperlinkText, this.fPropertiesKey);
    }

    private static class KeyReference
    extends PlatformObject
    implements IWorkbenchAdapter,
    Comparable<KeyReference> {
        private static final Collator fgCollator = Collator.getInstance();
        private IResource resource;
        private IJavaElement element;
        private int offset;
        private int length;
        private final boolean showLineNumber;

        private KeyReference(IResource resource, IJavaElement element, int offset, int length, boolean showLineNumber) {
            Assert.isNotNull((Object)resource);
            this.resource = resource;
            this.offset = offset;
            this.length = length;
            this.element = element;
            this.showLineNumber = showLineNumber;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == IWorkbenchAdapter.class) {
                return (T)this;
            }
            return (T)super.getAdapter(adapter);
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)this.resource.getAdapter(IWorkbenchAdapter.class);
            if (wbAdapter != null) {
                return wbAdapter.getImageDescriptor((Object)this.resource);
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getLabel(Object o) {
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            try {
                manager.connect(this.resource.getFullPath(), LocationKind.NORMALIZE, null);
                try {
                    ITextFileBuffer buffer = manager.getTextFileBuffer(this.resource.getFullPath(), LocationKind.NORMALIZE);
                    IDocument document = buffer.getDocument();
                    if (document == null) return BasicElementLabels.getPathLabel((IPath)this.resource.getFullPath(), (boolean)false);
                    int line = document.getLineOfOffset(this.offset) + 1;
                    String pathLabel = BasicElementLabels.getPathLabel((IPath)this.resource.getFullPath(), (boolean)false);
                    Object[] args = new Object[]{new Integer(line), pathLabel};
                    String string = this.showLineNumber ? Messages.format(PropertiesFileEditorMessages.OpenAction_SelectionDialog_elementLabel, args) : pathLabel;
                    return string;
                }
                finally {
                    manager.disconnect(this.resource.getFullPath(), LocationKind.NORMALIZE, null);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e.getStatus());
                return BasicElementLabels.getPathLabel((IPath)this.resource.getFullPath(), (boolean)false);
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
            }
            return BasicElementLabels.getPathLabel((IPath)this.resource.getFullPath(), (boolean)false);
        }

        public Object getParent(Object o) {
            return null;
        }

        @Override
        public int compareTo(KeyReference otherRef) {
            String otherPath;
            String thisPath = this.resource.getFullPath().toString();
            int result = fgCollator.compare(thisPath, otherPath = otherRef.resource.getFullPath().toString());
            if (result != 0) {
                return result;
            }
            return this.offset - otherRef.offset;
        }
    }

    private static class ResultCollector
    extends TextSearchRequestor {
        private final List<KeyReference> fResult;
        private final boolean fIsKeyDoubleQuoted;

        public ResultCollector(List<KeyReference> result, boolean isKeyDoubleQuoted) {
            this.fResult = result;
            this.fIsKeyDoubleQuoted = isKeyDoubleQuoted;
        }

        public boolean canRunInParallel() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
            int start = matchAccess.getMatchOffset();
            int length = matchAccess.getMatchLength();
            if (this.fIsKeyDoubleQuoted) {
                ++start;
                length -= 2;
            }
            List<KeyReference> list = this.fResult;
            synchronized (list) {
                this.fResult.add(new KeyReference((IResource)matchAccess.getFile(), null, start, length, true));
            }
            return true;
        }
    }
}

