/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.cleanup;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.CodeFormatCleanUp;
import org.eclipse.jdt.internal.ui.fix.ImportsCleanUp;
import org.eclipse.jdt.internal.ui.fix.SortMembersCleanUp;
import org.eclipse.jdt.internal.ui.preferences.cleanup.AbstractCleanUpTabPage;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpMessages;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public final class CodeFormatingTabPage
extends AbstractCleanUpTabPage {
    public static final String ID = "org.eclipse.jdt.ui.cleanup.tabpage.code_formatting";
    private Map<String, String> fValues;
    private CleanUpPreview fPreview;

    @Override
    public void setWorkingValues(Map<String, String> workingValues) {
        super.setWorkingValues(workingValues);
        this.fValues = workingValues;
    }

    @Override
    protected AbstractCleanUp[] createPreviewCleanUps(Map<String, String> values) {
        return new AbstractCleanUp[]{new ImportsCleanUp(values), new CodeFormatCleanUp(values), new SortMembersCleanUp(values)};
    }

    @Override
    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fPreview = (CleanUpPreview)super.doCreateJavaPreview(parent);
        this.fPreview.showInvisibleCharacters(true);
        this.fPreview.setFormat("true".equals(this.fValues.get("cleanup.format_source_code")));
        this.fPreview.setCorrectIndentation("true".equals(this.fValues.get("cleanup.correct_indentation")));
        return this.fPreview;
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group group = this.createGroup(numColumns, composite, CleanUpMessages.CodeFormatingTabPage_GroupName_Formatter);
        if (!this.isSaveAction()) {
            final ModifyDialogTabPage.CheckboxPreference format = this.createCheckboxPref((Composite)group, numColumns, CleanUpMessages.CodeFormatingTabPage_CheckboxName_FormatSourceCode, "cleanup.format_source_code", CleanUpModifyDialog.FALSE_TRUE);
            this.registerPreference(format);
            format.addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    CodeFormatingTabPage.this.fPreview.setFormat(format.getChecked());
                    CodeFormatingTabPage.this.fPreview.update();
                }
            });
        }
        ModifyDialogTabPage.CheckboxPreference whiteSpace = this.createCheckboxPref((Composite)group, numColumns, CleanUpMessages.CodeFormatingTabPage_RemoveTrailingWhitespace_checkbox_text, "cleanup.remove_trailing_whitespaces", CleanUpModifyDialog.FALSE_TRUE);
        this.intent((Composite)group);
        ModifyDialogTabPage.RadioPreference allPref = this.createRadioPref((Composite)group, 1, CleanUpMessages.CodeFormatingTabPage_RemoveTrailingWhitespace_all_radio, "cleanup.remove_trailing_whitespaces_all", CleanUpModifyDialog.FALSE_TRUE);
        ModifyDialogTabPage.RadioPreference ignoreEmptyPref = this.createRadioPref((Composite)group, 1, CleanUpMessages.CodeFormatingTabPage_RemoveTrailingWhitespace_ignoreEmpty_radio, "cleanup.remove_trailing_whitespaces_ignore_empty", CleanUpModifyDialog.FALSE_TRUE);
        this.registerSlavePreference(whiteSpace, new ModifyDialogTabPage.RadioPreference[]{allPref, ignoreEmptyPref});
        final ModifyDialogTabPage.CheckboxPreference correctIndentation = this.createCheckboxPref((Composite)group, numColumns, CleanUpMessages.CodeFormatingTabPage_correctIndentation_checkbox_text, "cleanup.correct_indentation", CleanUpModifyDialog.FALSE_TRUE);
        this.registerPreference(correctIndentation);
        correctIndentation.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                CodeFormatingTabPage.this.fPreview.setCorrectIndentation(correctIndentation.getChecked());
                CodeFormatingTabPage.this.fPreview.update();
            }
        });
        if (!this.isSaveAction()) {
            CodeFormatingTabPage.createLabel(numColumns, (Composite)group, CleanUpMessages.CodeFormatingTabPage_FormatterSettings_Description).setFont(composite.getFont());
            Group importsGroup = this.createGroup(numColumns, composite, CleanUpMessages.CodeFormatingTabPage_Imports_GroupName);
            ModifyDialogTabPage.CheckboxPreference organizeImports = this.createCheckboxPref((Composite)importsGroup, numColumns, CleanUpMessages.CodeFormatingTabPage_OrganizeImports_CheckBoxLable, "cleanup.organize_imports", CleanUpModifyDialog.FALSE_TRUE);
            this.registerPreference(organizeImports);
            CodeFormatingTabPage.createLabel(numColumns, (Composite)importsGroup, CleanUpMessages.CodeFormatingTabPage_OrganizeImportsSettings_Description).setFont(composite.getFont());
        }
        Group sortMembersGroup = this.createGroup(numColumns, composite, CleanUpMessages.CodeFormatingTabPage_SortMembers_GroupName);
        final ModifyDialogTabPage.CheckboxPreference sortMembersPref = this.createCheckboxPref((Composite)sortMembersGroup, numColumns, CleanUpMessages.CodeFormatingTabPage_SortMembers_CheckBoxLabel, "cleanup.sort_members", CleanUpModifyDialog.FALSE_TRUE);
        this.intent((Composite)sortMembersGroup);
        final Button nullRadio = new Button((Composite)sortMembersGroup, 16);
        nullRadio.setText(CleanUpMessages.CodeFormatingTabPage_SortMembersExclusive_radio0);
        nullRadio.setLayoutData((Object)CodeFormatingTabPage.createGridData(numColumns - 1, 768, -1));
        nullRadio.setFont(composite.getFont());
        this.intent((Composite)sortMembersGroup);
        final ModifyDialogTabPage.RadioPreference sortAllPref = this.createRadioPref((Composite)sortMembersGroup, numColumns - 1, CleanUpMessages.CodeFormatingTabPage_SortMembersFields_CheckBoxLabel, "cleanup.sort_members_all", CleanUpModifyDialog.FALSE_TRUE);
        this.intent((Composite)sortMembersGroup);
        final Label warningImage = new Label((Composite)sortMembersGroup, 16448);
        warningImage.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
        warningImage.setLayoutData((Object)new GridData(1, 2, false, false));
        final Label warningLabel = CodeFormatingTabPage.createLabel(numColumns - 2, (Composite)sortMembersGroup, CleanUpMessages.CodeFormatingTabPage_SortMembersSemanticChange_warning);
        this.registerSlavePreference(sortMembersPref, new ModifyDialogTabPage.RadioPreference[]{sortAllPref});
        sortMembersPref.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                nullRadio.setEnabled(sortMembersPref.getChecked());
                boolean warningEnabled = sortMembersPref.getChecked() && sortAllPref.getChecked();
                warningImage.setEnabled(warningEnabled);
                warningLabel.setEnabled(warningEnabled);
            }
        });
        sortAllPref.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                boolean warningEnabled = sortMembersPref.getChecked() && sortAllPref.getChecked();
                warningImage.setEnabled(warningEnabled);
                warningLabel.setEnabled(warningEnabled);
            }
        });
        nullRadio.setEnabled(sortMembersPref.getChecked());
        nullRadio.setSelection("false".equals(this.fValues.get("cleanup.sort_members_all")));
        boolean warningEnabled = sortMembersPref.getChecked() && sortAllPref.getChecked();
        warningImage.setEnabled(warningEnabled);
        warningLabel.setEnabled(warningEnabled);
        CodeFormatingTabPage.createLabel(numColumns, (Composite)sortMembersGroup, CleanUpMessages.CodeFormatingTabPage_SortMembers_Description);
    }
}

