/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.spans.ContainSpans;
import org.apache.lucene.search.spans.SpanContainQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;

public final class SpanWithinQuery
extends SpanContainQuery {
    public SpanWithinQuery(SpanQuery big, SpanQuery little) {
        super(big, little);
    }

    @Override
    public String toString(String field) {
        return this.toString(field, "SpanWithin");
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        SpanWeight bigWeight = this.big.createWeight(searcher, false);
        SpanWeight littleWeight = this.little.createWeight(searcher, false);
        return new SpanWithinWeight(searcher, needsScores ? SpanWithinQuery.getTermContexts(bigWeight, littleWeight) : null, bigWeight, littleWeight);
    }

    public class SpanWithinWeight
    extends SpanContainQuery.SpanContainWeight {
        public SpanWithinWeight(IndexSearcher searcher, Map<Term, TermContext> terms, SpanWeight bigWeight, SpanWeight littleWeight) throws IOException {
            super(searcher, terms, bigWeight, littleWeight);
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            ArrayList<Spans> containerContained = this.prepareConjunction(context, requiredPostings);
            if (containerContained == null) {
                return null;
            }
            Spans big = containerContained.get(0);
            Spans little = containerContained.get(1);
            return new ContainSpans(big, little, little){

                @Override
                boolean twoPhaseCurrentDocMatches() throws IOException {
                    this.oneExhaustedInCurrentDoc = false;
                    assert (this.littleSpans.startPosition() == -1);
                    while (this.littleSpans.nextStartPosition() != Integer.MAX_VALUE) {
                        while (this.bigSpans.endPosition() < this.littleSpans.endPosition()) {
                            if (this.bigSpans.nextStartPosition() != Integer.MAX_VALUE) continue;
                            this.oneExhaustedInCurrentDoc = true;
                            return false;
                        }
                        if (this.bigSpans.startPosition() > this.littleSpans.startPosition()) continue;
                        this.atFirstInCurrentDoc = true;
                        return true;
                    }
                    this.oneExhaustedInCurrentDoc = true;
                    return false;
                }

                @Override
                public int nextStartPosition() throws IOException {
                    if (this.atFirstInCurrentDoc) {
                        this.atFirstInCurrentDoc = false;
                        return this.littleSpans.startPosition();
                    }
                    while (this.littleSpans.nextStartPosition() != Integer.MAX_VALUE) {
                        while (this.bigSpans.endPosition() < this.littleSpans.endPosition()) {
                            if (this.bigSpans.nextStartPosition() != Integer.MAX_VALUE) continue;
                            this.oneExhaustedInCurrentDoc = true;
                            return Integer.MAX_VALUE;
                        }
                        if (this.bigSpans.startPosition() > this.littleSpans.startPosition()) continue;
                        return this.littleSpans.startPosition();
                    }
                    this.oneExhaustedInCurrentDoc = true;
                    return Integer.MAX_VALUE;
                }
            };
        }
    }
}

