/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProductFeature
extends ProductObject
implements IProductFeature {
    private static final long serialVersionUID = 1L;
    private String fId;
    private String fVersion;
    private String fInstallMode;

    public ProductFeature(IProductModel model) {
        super(model);
    }

    @Override
    public void parse(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            this.fId = element.getAttribute("id");
            this.fVersion = element.getAttribute("version");
            this.fInstallMode = element.getAttribute("installMode");
        }
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.print(String.valueOf(indent) + "<feature id=\"" + this.fId + "\"");
        if (this.fVersion != null && this.fVersion.length() > 0 && !this.fVersion.equals("0.0.0")) {
            writer.print(" version=\"" + this.fVersion + "\"");
        }
        if (this.fInstallMode != null && !this.fInstallMode.equals("")) {
            writer.print(" installMode=\"" + this.fInstallMode + "\"");
        }
        writer.println("/>");
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public void setId(String id) {
        this.fId = id;
    }

    @Override
    public String getVersion() {
        return this.fVersion;
    }

    @Override
    public void setVersion(String version) {
        String old = this.fVersion;
        this.fVersion = version;
        if (this.isEditable()) {
            this.firePropertyChanged("version", old, this.fVersion);
        }
    }
}

