/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;

public class CallHierarchyImageDescriptor
extends CompositeImageDescriptor {
    public static final int RECURSIVE = 1;
    public static final int MAX_LEVEL = 2;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public CallHierarchyImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (object == null || !CallHierarchyImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        CallHierarchyImageDescriptor other = (CallHierarchyImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage) && this.fFlags == other.fFlags && this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        CompositeImageDescriptor.CachedImageDataProvider bg = this.createCachedImageDataProvider(this.fBaseImage);
        this.drawImage((ImageDataProvider)bg, 0, 0);
        this.drawBottomLeft();
    }

    private void drawBottomLeft() {
        Point size = this.getSize();
        int x = 0;
        CompositeImageDescriptor.CachedImageDataProvider dataProvider = null;
        if ((this.fFlags & 1) != 0) {
            dataProvider = this.createCachedImageDataProvider(JavaPluginImages.DESC_OVR_RECURSIVE);
            this.drawImage((ImageDataProvider)dataProvider, x, size.y - dataProvider.getHeight());
            x += dataProvider.getWidth();
        }
        if ((this.fFlags & 2) != 0) {
            dataProvider = this.createCachedImageDataProvider(JavaPluginImages.DESC_OVR_MAX_LEVEL);
            this.drawImage((ImageDataProvider)dataProvider, x, size.y - dataProvider.getHeight());
            x += dataProvider.getWidth();
        }
    }
}

