/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;

public class TightSourceRangeComputer
extends TargetSourceRangeComputer {
    private HashSet<ASTNode> fTightSourceRangeNodes = new HashSet();

    public void addTightSourceNode(ASTNode reference) {
        this.fTightSourceRangeNodes.add(reference);
        List properties = reference.structuralPropertiesForType();
        for (StructuralPropertyDescriptor descriptor : properties) {
            if (descriptor.isChildProperty()) {
                ASTNode child = (ASTNode)reference.getStructuralProperty(descriptor);
                if (child == null || !this.isExtending(child, reference)) continue;
                this.addTightSourceNode(child);
                continue;
            }
            if (!descriptor.isChildListProperty()) continue;
            List children = ASTNodes.getChildListProperty((ASTNode)reference, (ChildListPropertyDescriptor)((ChildListPropertyDescriptor)descriptor));
            for (ASTNode child : children) {
                if (!this.isExtending(child, reference)) continue;
                this.addTightSourceNode(child);
            }
        }
    }

    public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode node) {
        if (this.fTightSourceRangeNodes.contains(node)) {
            return new TargetSourceRangeComputer.SourceRange(node.getStartPosition(), node.getLength());
        }
        return super.computeSourceRange(node);
    }

    private boolean isExtending(ASTNode child, ASTNode parent) {
        int extendedEnd;
        int extendedStart;
        TargetSourceRangeComputer.SourceRange extendedRange = super.computeSourceRange(child);
        int parentStart = parent.getStartPosition();
        if (parentStart > (extendedStart = extendedRange.getStartPosition())) {
            return true;
        }
        int parentEnd = parentStart + parent.getLength();
        return parentEnd < (extendedEnd = extendedStart + extendedRange.getLength());
    }
}

