/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.text.edits.TextEditGroup;

public class BodyDeclarationRewrite {
    private ASTNode fTypeNode;
    private ListRewrite fListRewrite;

    public static BodyDeclarationRewrite create(ASTRewrite rewrite, ASTNode typeNode) {
        return new BodyDeclarationRewrite(rewrite, typeNode);
    }

    private BodyDeclarationRewrite(ASTRewrite rewrite, ASTNode typeNode) {
        ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty((ASTNode)typeNode);
        this.fTypeNode = typeNode;
        this.fListRewrite = rewrite.getListRewrite(typeNode, property);
    }

    public void insert(BodyDeclaration decl, TextEditGroup description) {
        List container = ASTNodes.getBodyDeclarations((ASTNode)this.fTypeNode);
        int index = BodyDeclarationRewrite.getInsertionIndex(decl, container);
        this.fListRewrite.insertAt((ASTNode)decl, index, description);
    }

    public static int getInsertionIndex(BodyDeclaration member, List<? extends BodyDeclaration> container) {
        int containerSize = container.size();
        MembersOrderPreferenceCache orderStore = JavaPlugin.getDefault().getMemberOrderPreferenceCache();
        int orderIndex = BodyDeclarationRewrite.getOrderPreference(member, orderStore);
        int insertPos = containerSize;
        int insertPosOrderIndex = -1;
        int i = containerSize - 1;
        while (i >= 0) {
            int currOrderIndex = BodyDeclarationRewrite.getOrderPreference(container.get(i), orderStore);
            if (orderIndex == currOrderIndex) {
                if (insertPosOrderIndex != orderIndex) {
                    insertPos = i + 1;
                    insertPosOrderIndex = orderIndex;
                }
            } else if (insertPosOrderIndex != orderIndex) {
                if (currOrderIndex < orderIndex) {
                    if (insertPosOrderIndex == -1) {
                        insertPos = i + 1;
                        insertPosOrderIndex = currOrderIndex;
                    }
                } else {
                    insertPos = i;
                    insertPosOrderIndex = currOrderIndex;
                }
            }
            --i;
        }
        return insertPos;
    }

    private static int getOrderPreference(BodyDeclaration member, MembersOrderPreferenceCache store) {
        int memberType = member.getNodeType();
        int modifiers = member.getModifiers();
        switch (memberType) {
            case 55: 
            case 71: 
            case 81: {
                return store.getCategoryIndex(0) * 2;
            }
            case 23: {
                if (Modifier.isStatic((int)modifiers)) {
                    int index = store.getCategoryIndex(5) * 2;
                    if (Modifier.isFinal((int)modifiers)) {
                        return index;
                    }
                    return index + 1;
                }
                return store.getCategoryIndex(3) * 2;
            }
            case 28: {
                if (Modifier.isStatic((int)modifiers)) {
                    return store.getCategoryIndex(6) * 2;
                }
                return store.getCategoryIndex(4) * 2;
            }
            case 82: {
                return store.getCategoryIndex(2) * 2;
            }
            case 31: {
                if (Modifier.isStatic((int)modifiers)) {
                    return store.getCategoryIndex(7) * 2;
                }
                if (((MethodDeclaration)member).isConstructor()) {
                    return store.getCategoryIndex(1) * 2;
                }
                return store.getCategoryIndex(2) * 2;
            }
        }
        return 100;
    }
}

