/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.toc.text;

import java.util.Collection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ua.core.toc.text.TocModel;
import org.xml.sax.SAXParseException;

public class TocMarkerManager {
    public static void refreshMarkers(TocModel model) {
        TocMarkerManager.deleteMarkers(model);
        TocMarkerManager.createMarkers(model);
    }

    public static void deleteMarkers(TocModel model) {
        try {
            if (model.getUnderlyingResource() == null) {
                return;
            }
            IMarker[] problems = model.getUnderlyingResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            if (problems != null) {
                IMarker[] iMarkerArray = problems;
                int n = problems.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker problem = iMarkerArray[n2];
                    problem.delete();
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            PDECore.log((Throwable)e);
        }
    }

    public static void createMarkers(TocModel model) {
        Collection<Exception> errors = model.getErrors();
        if (errors == null || errors.size() == 0) {
            return;
        }
        for (Throwable throwable : errors) {
            if (!(throwable instanceof SAXParseException)) continue;
            int line = ((SAXParseException)throwable).getLineNumber();
            try {
                IMarker marker = model.getUnderlyingResource().createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("lineNumber", line);
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)throwable.getLocalizedMessage());
            }
            catch (CoreException e) {
                PDECore.log((Throwable)e);
            }
        }
    }
}

