/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.preferences.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.rcptt.core.IContextProcessor;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.ctx.preferences.impl.Activator;
import org.eclipse.rcptt.ctx.preferences.impl.DialogSettingsUtils;
import org.eclipse.rcptt.ctx.preferences.impl.ResourcesSupport;
import org.eclipse.rcptt.ctx.preferences.impl.SecuritySupport;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.preferences.PrefUtils;
import org.eclipse.rcptt.preferences.PrefData;
import org.eclipse.rcptt.preferences.PrefNode;
import org.eclipse.rcptt.preferences.PreferencesContext;
import org.eclipse.rcptt.preferences.PreferencesFactory;
import org.eclipse.rcptt.preferences.SecurePrefNode;
import org.eclipse.rcptt.preferences.SettingsNode;
import org.eclipse.rcptt.preferences.StringPrefData;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.ecl.impl.UIRunnable;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.UIJobCollector;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesContextProcessor
implements IContextProcessor {
    private static final String DIALOG_SETTINGS_NODE_NAME = "settings";
    private static final String SECURE_PREFERENCES_NODE_NAME = "secureStorage";
    private static final String[] EXCLUDE_SCOPE_LIST = new String[]{"default", "configuration"};

    public void apply(final Context contextToApply) throws CoreException {
        final UIJobCollector collector = new UIJobCollector();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)collector);
        SWTUIPlayer.disableMessageDialogs();
        try {
            try {
                UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

                    public Object run() throws CoreException {
                        collector.enable();
                        PreferencesContextProcessor.this.doApply((PreferencesContext)contextToApply);
                        return null;
                    }
                });
                UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

                    public Object run() throws CoreException {
                        collector.setNeedDisable();
                        return null;
                    }
                });
                collector.join((long)TeslaLimits.getJobTimeout());
            }
            catch (Exception e) {
                CoreException ee = new CoreException(RcpttPlugin.createStatus((String)("Failed to execute context: " + contextToApply.getName() + " Cause: " + e.getMessage()), (Throwable)e));
                RcpttPlugin.log((Throwable)e);
                throw ee;
            }
        }
        finally {
            SWTUIPlayer.enableMessageDialogs();
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)collector);
        }
    }

    public Context create(EObject param) throws CoreException {
        UIRunnable.exec((UIRunnable)new UIRunnable<PreferencesContext>(){

            public PreferencesContext run() throws CoreException {
                return null;
            }
        });
        return this.doCreate();
    }

    /*
     * Unable to fully structure code
     */
    private void doApply(PreferencesContext context) throws CoreException {
        service = Platform.getPreferencesService();
        rootPreferences = service.getRootNode();
        if (context.isCleanPreferences()) {
            try {
                var8_8 = rootChildsNames = rootPreferences.childrenNames();
                var7_9 = rootChildsNames.length;
                var6_11 = 0;
                while (var6_11 < var7_9) {
                    rootChild = var8_8[var6_11];
                    if (rootChild.equals("project") || rootChild.equals("instance")) {
                        rootChildNode = rootPreferences.node(rootChild);
                        this.removeSubNodes(rootChildNode);
                    }
                    ++var6_11;
                }
                rootPreferences.flush();
                rootPreferences.sync();
            }
            catch (BackingStoreException e) {
                throw new CoreException(Activator.createStatus("Could not clear preferences: " + e.getMessage(), e));
            }
            bundles = Activator.getDefault().getBundle().getBundleContext().getBundles();
            var8_8 = bundles;
            var7_9 = bundles.length;
            var6_11 = 0;
            while (var6_11 < var7_9) {
                bundle = var8_8[var6_11];
                DialogSettingsUtils.clearDialogSettings((Bundle)bundle);
                ++var6_11;
            }
        }
        try {
            for (PrefNode prefNode : context.getContent()) {
                block21: {
                    try {
                        if (prefNode instanceof SecurePrefNode) {
                            try {
                                SecuritySupport.applySecureSettings((SecurePrefNode)prefNode, context.isCleanPreferences());
                            }
                            catch (Throwable e) {
                                RcpttPlugin.log((Throwable)e);
                            }
                        }
                        this.applyPreferences(prefNode, (Preferences)rootPreferences, context.isCleanPreferences());
                        rootPreferences.flush();
                        continue;
                    }
                    catch (Throwable e) {
                        nodeName = prefNode.getName();
                        if (!nodeName.equals("project")) break block21;
                        childs = prefNode.getChilds();
                        ** for (child : childs)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            ResourcesSupport.checkProjectExistance(child, e);
                        }
                        catch (CoreException e4) {
                            throw e4;
                        }
                        catch (Throwable e3) {
                            RcpttPlugin.log((Throwable)e3);
                        }
                        continue;
                    }
                }
                throw new CoreException(Activator.createStatus("Error during preferences apply for node: \"" + nodeName + "\" caused by: (" + e.getMessage() + ")", e));
            }
            settingsNode = context.getSettings();
            if (settingsNode != null) {
                for (PrefNode prefNode : settingsNode.getChilds()) {
                    this.applyDialogSettings(prefNode);
                }
            }
            rootPreferences.flush();
        }
        catch (IOException e) {
            throw new CoreException(Activator.createStatus("Error during dialog settings applying.", e));
        }
        catch (BackingStoreException e) {
            throw new CoreException(Activator.createStatus("Error during dialog settings applying.", e));
        }
    }

    private void removeSubNodes(Preferences rootChildNode) throws BackingStoreException {
        String[] topChildNames;
        rootChildNode.clear();
        String[] stringArray = topChildNames = rootChildNode.childrenNames();
        int n = topChildNames.length;
        int n2 = 0;
        while (n2 < n) {
            String[] childrenNames;
            String key;
            int n3;
            int n4;
            String[] stringArray2;
            String topChild = stringArray[n2];
            Preferences topChildNode = rootChildNode.node(topChild);
            HashMap<String, String> storedProperties = new HashMap<String, String>();
            if (topChild.equals("org.eclipse.pde.core")) {
                stringArray2 = this.getPDECoreRequiredPreferencesList();
                n4 = stringArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    key = stringArray2[n3];
                    storedProperties.put(key, topChildNode.get(key, null));
                    ++n3;
                }
            }
            if (topChild.equals("org.eclipse.jdt.core")) {
                stringArray2 = this.getJDTCoreRequiredPreferencesList();
                n4 = stringArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    key = stringArray2[n3];
                    storedProperties.put(key, topChildNode.get(key, null));
                    ++n3;
                }
            }
            topChildNode.clear();
            try {
                topChildNode.flush();
            }
            catch (Throwable e) {
                Activator.log(e);
            }
            String[] stringArray3 = childrenNames = topChildNode.childrenNames();
            int n5 = childrenNames.length;
            n4 = 0;
            while (n4 < n5) {
                String child = stringArray3[n4];
                Preferences childNode = topChildNode.node(child);
                childNode.removeNode();
                ++n4;
            }
            for (Map.Entry e : storedProperties.entrySet()) {
                if (e.getValue() == null) continue;
                try {
                    topChildNode.put((String)e.getKey(), (String)e.getValue());
                }
                catch (Throwable throwable) {}
            }
            ++n2;
        }
        try {
            rootChildNode.flush();
        }
        catch (Throwable e) {
            Activator.log(e);
        }
    }

    private String[] getPDECoreRequiredPreferencesList() {
        String[] keys = new String[]{"org.eclipse.pde.ui.arch", "vm_args", "program_args", "org.eclipse.pde.ui.ws", "workspace_target_handle", "platform_path", "org.eclipse.pde.ui.os", "target_mode", "target.profile", "org.eclipse.pde.ui.nl", "pooled_urls", "pooled_bundles"};
        return keys;
    }

    private String[] getJDTCoreRequiredPreferencesList() {
        String[] keys = new String[]{"org.eclipse.jdt.core.classpathVariable.JRE_LIB", "org.eclipse.jdt.core.classpathVariable.JRE_SRC", "org.eclipse.jdt.core.classpathVariable.JRE_SRCROOT"};
        return keys;
    }

    private PreferencesContext doCreate() throws CoreException {
        try {
            PreferencesContext context = PreferencesFactory.eINSTANCE.createPreferencesContext();
            List<PrefNode> prefNodes = this.collectPreferences();
            context.getContent().addAll(prefNodes);
            SettingsNode settings = this.collectDialogSettings();
            if (settings.getChilds().size() > 0) {
                settings.setName(DIALOG_SETTINGS_NODE_NAME);
                context.setSettings(settings);
            }
            try {
                SecurePrefNode secureNode = SecuritySupport.collectSecureSettings();
                if (secureNode.getChilds().size() > 0) {
                    secureNode.setName(SECURE_PREFERENCES_NODE_NAME);
                    context.getContent().add((Object)secureNode);
                }
            }
            catch (Throwable e) {
                Activator.log(e);
            }
            return context;
        }
        catch (BackingStoreException e) {
            throw new CoreException(Activator.createStatus("Error during preferences processing.", e));
        }
        catch (IOException e) {
            throw new CoreException(Activator.createStatus("Error during dialog settings processing.", e));
        }
    }

    public boolean isApplied(Context context) {
        throw new UnsupportedOperationException();
    }

    public boolean isCreateAllowed() {
        return true;
    }

    private void applyPreferences(PrefNode currentPrefNode, Preferences parentPreferences, boolean clean) throws BackingStoreException {
        String key;
        int n;
        Object object;
        String nodeName = currentPrefNode.getName();
        Preferences preferences = parentPreferences.node(nodeName);
        HashMap<String, String> storedProperties = new HashMap<String, String>();
        if (nodeName.equals("org.eclipse.pde.core")) {
            object = this.getPDECoreRequiredPreferencesList();
            int n2 = ((String[])object).length;
            n = 0;
            while (n < n2) {
                key = object[n];
                storedProperties.put(key, preferences.get(key, null));
                ++n;
            }
        }
        if (nodeName.equals("org.eclipse.jdt.core")) {
            object = this.getJDTCoreRequiredPreferencesList();
            int n2 = ((String[])object).length;
            n = 0;
            while (n < n2) {
                key = object[n];
                storedProperties.put(key, preferences.get(key, null));
                ++n;
            }
        }
        if (clean) {
            this.removeSubNodes(preferences);
        }
        preferences = parentPreferences.node(currentPrefNode.getName());
        EList datas = currentPrefNode.getData();
        HashSet<String> datasSet = new HashSet<String>();
        for (PrefData prefData : datas) {
            Bundle ideBundle;
            StringPrefData prefData2 = (StringPrefData)prefData;
            datasSet.add(prefData.getKey());
            if (prefData2.getKey().startsWith("org.eclipse.ui.internal.views.markers.CachedMarkerBuilder") && (ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide")) != null && (((String)ideBundle.getHeaders().get("Bundle-Version")).toString().startsWith("3.5") || ((String)ideBundle.getHeaders().get("Bundle-Version")).toString().startsWith("3.4"))) continue;
            PrefUtils.decodePrefData((StringPrefData)prefData2);
            PrefUtils.decodeWorkspaceLocation((StringPrefData)prefData2);
            try {
                preferences.put(prefData2.getKey(), prefData2.getValue());
            }
            catch (Throwable throwable) {}
        }
        if (nodeName.equals("org.eclipse.ui.workbench") || datasSet.contains("OPEN_ON_SINGLE_CLICK")) {
            this.processOpenStrategy(preferences);
        }
        for (Map.Entry entry : storedProperties.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                preferences.put((String)entry.getKey(), (String)entry.getValue());
            }
            catch (Throwable throwable) {}
        }
        EList eList = currentPrefNode.getChilds();
        for (PrefNode child : eList) {
            try {
                this.applyPreferences(child, preferences, false);
            }
            catch (Throwable e) {
                RcpttPlugin.log((Throwable)e);
            }
        }
    }

    private void processOpenStrategy(Preferences preferences) {
        int singleClickMethod;
        boolean openOnSingleClick = preferences.getBoolean("OPEN_ON_SINGLE_CLICK", false);
        boolean selectOnHover = preferences.getBoolean("SELECT_ON_HOVER", false);
        boolean openAfterDelay = preferences.getBoolean("OPEN_AFTER_DELAY", false);
        int n = singleClickMethod = openOnSingleClick ? 1 : 0;
        if (openOnSingleClick) {
            if (selectOnHover) {
                singleClickMethod |= 2;
            }
            if (openAfterDelay) {
                singleClickMethod |= 4;
            }
        }
        OpenStrategy.setOpenMethod((int)singleClickMethod);
    }

    private List<PrefNode> collectPreferences() throws BackingStoreException {
        String[] childNames;
        ArrayList<PrefNode> result = new ArrayList<PrefNode>();
        IPreferencesService service = Platform.getPreferencesService();
        IEclipsePreferences root = service.getRootNode();
        String[] stringArray = childNames = root.childrenNames();
        int n = childNames.length;
        int n2 = 0;
        while (n2 < n) {
            PrefNode prefNode;
            String childName = stringArray[n2];
            Preferences child = root.node(childName);
            if (this.shouldProcess(child) && (prefNode = PrefUtils.convertPreferences((Preferences)child)) != null) {
                result.add(prefNode);
            }
            ++n2;
        }
        return result;
    }

    private boolean shouldProcess(Preferences preferences) {
        String[] stringArray = EXCLUDE_SCOPE_LIST;
        int n = EXCLUDE_SCOPE_LIST.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(preferences.name())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private SettingsNode collectDialogSettings() throws IOException {
        Bundle[] bundles;
        SettingsNode settings = PreferencesFactory.eINSTANCE.createSettingsNode();
        settings.setName(DIALOG_SETTINGS_NODE_NAME);
        Bundle[] bundleArray = bundles = Activator.getDefault().getBundle().getBundleContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            PrefNode prefNode = DialogSettingsUtils.collectDialogSettings(bundle);
            if (prefNode != null) {
                prefNode.setName(bundle.getSymbolicName());
                settings.getChilds().add((Object)prefNode);
            }
            ++n2;
        }
        return settings;
    }

    private void applyDialogSettings(PrefNode prefNode) throws IOException {
        Bundle bundle = Platform.getBundle((String)prefNode.getName());
        if (bundle != null) {
            DialogSettingsUtils.applyDialogSettings(bundle, prefNode);
        }
    }
}

