/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

public class AddToIndexOperation
implements IEGitOperation {
    private final Collection<? extends IResource> rsrcList;

    public AddToIndexOperation(Collection<? extends IResource> rsrcs) {
        this.rsrcList = rsrcs;
    }

    public AddToIndexOperation(IResource[] resources) {
        this.rsrcList = Arrays.asList(resources);
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.rsrcList.size() * 2));
        HashMap<RepositoryMapping, AddCommand> addCommands = new HashMap<RepositoryMapping, AddCommand>();
        try {
            for (IResource iResource : this.rsrcList) {
                this.addToCommand(iResource, addCommands);
                progress.worked(1);
            }
            progress.setWorkRemaining(addCommands.size());
            for (AddCommand addCommand : addCommands.values()) {
                addCommand.call();
                progress.worked(1);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new CoreException(Activator.error(CoreText.AddToIndexOperation_failed, runtimeException));
        }
        catch (GitAPIException gitAPIException) {
            throw new CoreException(Activator.error(CoreText.AddToIndexOperation_failed, gitAPIException));
        }
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRuleForRepositories(this.rsrcList.toArray(new IResource[this.rsrcList.size()]));
    }

    private void addToCommand(IResource resource, Map<RepositoryMapping, AddCommand> addCommands) {
        String filepattern;
        RepositoryMapping map = RepositoryMapping.getMapping(resource);
        if (map == null) {
            return;
        }
        AddCommand command = addCommands.get(map);
        if (command == null) {
            Repository repo = map.getRepository();
            Throwable throwable = null;
            Object var7_8 = null;
            try (Git git = new Git(repo);){
                command = git.add();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            addCommands.put(map, command);
        }
        if ("".equals(filepattern = map.getRepoRelativePath(resource))) {
            filepattern = ".";
        }
        command.addFilepattern(filepattern);
    }
}

