/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.internal.ui.OpenSearchDialogAction;
import org.eclipse.search.internal.ui.SearchPageDescriptor;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class OpenSearchDialogPageAction
implements IWorkbenchWindowPulldownDelegate2 {
    private IWorkbenchWindow fWorkbenchWindow;
    private OpenSearchDialogAction fOpenSearchDialogAction;

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        this.fillMenu(menu);
        return menu;
    }

    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        this.fillMenu(menu);
        return menu;
    }

    public void dispose() {
        if (this.fOpenSearchDialogAction != null) {
            this.fOpenSearchDialogAction.dispose();
        }
    }

    public void init(IWorkbenchWindow window) {
        this.fWorkbenchWindow = window;
    }

    public void run(IAction action) {
        if (this.fOpenSearchDialogAction == null) {
            this.fOpenSearchDialogAction = new OpenSearchDialogAction();
        }
        this.fOpenSearchDialogAction.run(action);
    }

    public void selectionChanged(IAction action, ISelection sel) {
    }

    private void fillMenu(final Menu localMenu) {
        List<SearchPageDescriptor> pageDescriptors = SearchPlugin.getDefault().getSearchPageDescriptors();
        int accelerator = 1;
        for (SearchPageDescriptor desc : pageDescriptors) {
            if (WorkbenchActivityHelper.filterItem((Object)desc) || !desc.isEnabled()) continue;
            SearchPageAction action = new SearchPageAction(this.fWorkbenchWindow, desc);
            this.addToMenu(localMenu, (IAction)action, accelerator++);
        }
        localMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                e.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        localMenu.dispose();
                    }
                });
            }
        });
    }

    private void addToMenu(Menu localMenu, IAction action, int accelerator) {
        StringBuffer label = new StringBuffer();
        if (accelerator >= 0 && accelerator < 10) {
            label.append('&');
            label.append(accelerator);
            label.append(' ');
        }
        label.append(action.getText());
        action.setText(label.toString());
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(localMenu, -1);
    }

    private static final class SearchPageAction
    extends Action {
        private final OpenSearchDialogAction fOpenSearchDialogAction;

        public SearchPageAction(IWorkbenchWindow workbenchWindow, SearchPageDescriptor pageDescriptor) {
            this.fOpenSearchDialogAction = new OpenSearchDialogAction(workbenchWindow, pageDescriptor.getId());
            this.init(pageDescriptor);
        }

        private void init(SearchPageDescriptor pageDesc) {
            this.setText(pageDesc.getLabel());
            this.setToolTipText(pageDesc.getLabel());
            ImageDescriptor imageDescriptor = pageDesc.getImage();
            if (imageDescriptor != null) {
                this.setImageDescriptor(imageDescriptor);
            }
        }

        public void run() {
            this.fOpenSearchDialogAction.run((IAction)this);
        }
    }
}

