/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;

public class RefactoringScanner {
    private static int NO_MATCH = 0;
    private static int MATCH_QUALIFIED = 1;
    private static int MATCH_UNQUALIFIED = 2;
    private final String fName;
    private final String fQualifier;
    private IScanner fScanner;
    private Set<TextMatch> fMatches;

    public RefactoringScanner(String name, String qualifier) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)qualifier);
        this.fName = name;
        this.fQualifier = qualifier;
    }

    public void scan(ICompilationUnit cu) throws JavaModelException {
        char[] chars = cu.getBuffer().getCharacters();
        this.fMatches = new HashSet<TextMatch>();
        this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        this.fScanner.setSource(chars);
        this.doScan();
        this.fScanner = null;
    }

    public void scan(String text) {
        char[] chars = text.toCharArray();
        this.fMatches = new HashSet<TextMatch>();
        this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        this.fScanner.setSource(chars);
        this.doScan();
        this.fScanner = null;
    }

    private void doScan() {
        try {
            int token = this.fScanner.getNextToken();
            while (token != 158) {
                switch (token) {
                    case 45: 
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        this.parseCurrentToken();
                    }
                }
                token = this.fScanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {}
    }

    private static boolean isWholeWord(String value, int from, int to) {
        char ch;
        if (from > 0 && (Character.isLetterOrDigit(ch = value.charAt(from - 1)) || ch == '_')) {
            return false;
        }
        return to >= value.length() || !Character.isLetterOrDigit(ch = value.charAt(to)) && ch != '_';
    }

    private void parseCurrentToken() {
        String value = new String(this.fScanner.getRawTokenSource());
        int start = this.fScanner.getCurrentTokenStartPosition();
        int index = value.indexOf(this.fName);
        while (index != -1) {
            int ok;
            if (RefactoringScanner.isWholeWord(value, index, index + this.fName.length()) && (ok = this.isQualifierOK(value, index)) > NO_MATCH) {
                this.addMatch(start + index, ok);
            }
            index = value.indexOf(this.fName, index + 1);
        }
    }

    private int isQualifierOK(String value, int nameStart) {
        int qualifierAfter = nameStart - 1;
        if (qualifierAfter < 0) {
            return MATCH_UNQUALIFIED;
        }
        char charBeforeName = value.charAt(qualifierAfter);
        if (!this.isQualifierSeparator(charBeforeName)) {
            return MATCH_UNQUALIFIED;
        }
        boolean canFinish = charBeforeName == '#';
        int i = 0;
        while (i < this.fQualifier.length()) {
            char goalQualifierChar;
            int qualifierCharPos = qualifierAfter - 1 - i;
            if (qualifierCharPos < 0) {
                return canFinish ? MATCH_UNQUALIFIED : NO_MATCH;
            }
            char qualifierChar = value.charAt(qualifierCharPos);
            if (qualifierChar != (goalQualifierChar = this.fQualifier.charAt(this.fQualifier.length() - 1 - i))) {
                return canFinish && !this.isQualifierPart(qualifierChar) ? MATCH_UNQUALIFIED : NO_MATCH;
            }
            canFinish = !this.isQualifierSeparator(qualifierChar);
            ++i;
        }
        int beforeQualifierPos = qualifierAfter - this.fQualifier.length() - 1;
        if (beforeQualifierPos >= 0) {
            char precedingOne;
            char beforeQualifierChar = value.charAt(beforeQualifierPos);
            if (Character.isJavaIdentifierPart(beforeQualifierChar)) {
                return NO_MATCH;
            }
            if (this.isQualifierSeparator(beforeQualifierChar) && beforeQualifierPos > 0 && Character.isJavaIdentifierPart(precedingOne = value.charAt(beforeQualifierPos - 1))) {
                return NO_MATCH;
            }
            return MATCH_QUALIFIED;
        }
        return MATCH_QUALIFIED;
    }

    private boolean isQualifierPart(char ch) {
        return Character.isJavaIdentifierPart(ch) || this.isQualifierSeparator(ch);
    }

    private boolean isQualifierSeparator(char c) {
        return ".#".indexOf(c) != -1;
    }

    private void addMatch(int matchStart, int matchCode) {
        this.fMatches.add(new TextMatch(matchStart, matchCode == MATCH_QUALIFIED));
    }

    public Set<TextMatch> getMatches() {
        return this.fMatches;
    }

    public static class TextMatch {
        private int fStartPosition;
        private boolean fQualified;

        private TextMatch(int startPosition, boolean qualified) {
            this.fStartPosition = startPosition;
            this.fQualified = qualified;
        }

        public int getStartPosition() {
            return this.fStartPosition;
        }

        public boolean isQualified() {
            return this.fQualified;
        }
    }
}

