/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.jdt.internal.core.manipulation.search.SearchMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.search.JavaElementLine;
import org.eclipse.jdt.internal.ui.search.OccurrenceMatch;
import org.eclipse.jdt.internal.ui.search.TextSearchLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;

class OccurrencesSearchLabelProvider
extends TextSearchLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public OccurrencesSearchLabelProvider(AbstractTextSearchViewPage page) {
        super(page);
    }

    public String getText(Object element) {
        return this.getLabelWithCounts(element, this.internalGetText(element));
    }

    private String getLineNumberLabel(JavaElementLine element) {
        return Messages.format(SearchMessages.OccurrencesSearchLabelProvider_line_number, new Integer(element.getLineNumber() + 1));
    }

    private String internalGetText(Object element) {
        JavaElementLine jel = (JavaElementLine)element;
        return String.valueOf(this.getLineNumberLabel(jel)) + jel.getLineContents();
    }

    private StyledString internalGetRichText(Object element) {
        JavaElementLine jel = (JavaElementLine)element;
        String lineNumberString = this.getLineNumberLabel(jel);
        StyledString.Styler highlightStyle = ColoringLabelProvider.HIGHLIGHT_STYLE;
        StyledString res = new StyledString();
        res.append(lineNumberString, StyledString.QUALIFIER_STYLER);
        res.append(jel.getLineContents());
        Match[] matches = this.getPage().getInput().getMatches((Object)jel);
        int i = 0;
        while (i < matches.length) {
            OccurrenceMatch curr = (OccurrenceMatch)matches[i];
            int offset = curr.getOriginalOffset() - jel.getLineStartOffset() + lineNumberString.length();
            int length = curr.getOriginalLength();
            if (offset >= 0 && offset + length <= res.length()) {
                if ((curr.getFlags() & 1) != 0) {
                    res.setStyle(offset, length, ColoringLabelProvider.HIGHLIGHT_WRITE_STYLE);
                } else {
                    res.setStyle(offset, length, highlightStyle);
                }
            }
            ++i;
        }
        return res;
    }

    public Image getImage(Object element) {
        if (element instanceof JavaElementLine) {
            int flags = ((JavaElementLine)element).getFlags();
            if ((flags & 1) != 0) {
                return JavaPluginImages.get("org.eclipse.jdt.ui.occ_write.gif");
            }
            if ((flags & 2) != 0) {
                return JavaPluginImages.get("org.eclipse.jdt.ui.occ_read.gif");
            }
            if ((flags & 8) != 0) {
                return JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
            }
        }
        return JavaPluginImages.get("org.eclipse.jdt.ui.occ_match.gif");
    }

    public StyledString getStyledText(Object element) {
        return this.getColoredLabelWithCounts(element, this.internalGetRichText(element));
    }
}

