/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.css.swt.dom.scrollbar;

import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.internal.css.swt.dom.scrollbar.AbstractScrollHandler;
import org.eclipse.e4.ui.internal.css.swt.dom.scrollbar.IScrollBarSettings;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;

public abstract class AbstractThemedScrollBarAdapter
implements ControlListener,
Listener,
DisposeListener,
KeyListener,
MouseWheelListener,
SelectionListener {
    protected final IScrollBarSettings fScrollBarSettings;
    protected final Scrollable fScrollable;
    protected final IScrollBarPainter fPainter;
    protected final AbstractScrollHandler fHorizontalScrollHandler;
    protected final AbstractScrollHandler fVerticalScrollHandler;
    private final Display fDisplay;
    protected Point fLastHorizontalAndTopPixel = null;
    private Cursor fOldCursor;
    private final ScrollOnMouseDownRunnable fScrollOnMouseDownTimer;
    protected boolean installed = false;
    private static final boolean isWindowsOS = "win32".equals(Platform.getOS());

    public AbstractThemedScrollBarAdapter(Scrollable scrollable, AbstractScrollHandler horizontalScrollHandler, AbstractScrollHandler verticalScrollHandler, IScrollBarSettings scrollBarSettings) {
        this.fScrollable = scrollable;
        this.fScrollBarSettings = scrollBarSettings;
        this.fHorizontalScrollHandler = horizontalScrollHandler;
        this.fVerticalScrollHandler = verticalScrollHandler;
        this.fPainter = this.createPaintListener();
        this.fDisplay = Display.getCurrent();
        this.fScrollOnMouseDownTimer = new ScrollOnMouseDownRunnable(this.fScrollable, this.fDisplay);
    }

    protected void install() {
        if (this.fScrollable.isDisposed() || this.fDisplay.isDisposed() || this.installed) {
            return;
        }
        this.installed = true;
        this.fHorizontalScrollHandler.install(this);
        this.fVerticalScrollHandler.install(this);
        this.fDisplay.addFilter(3, (Listener)this);
        this.fDisplay.addFilter(4, (Listener)this);
        this.fDisplay.addFilter(5, (Listener)this);
        this.fDisplay.addFilter(35, (Listener)this);
        this.fScrollable.addControlListener((ControlListener)this);
        this.fScrollable.addKeyListener((KeyListener)this);
        this.fScrollable.addMouseWheelListener((MouseWheelListener)this);
        this.fScrollable.addDisposeListener((DisposeListener)this);
        this.fScrollable.addPaintListener((PaintListener)this.fPainter);
        this.fPainter.install(this.fScrollable);
    }

    protected void uninstall(boolean disposing) {
        if (!this.installed) {
            return;
        }
        this.installed = false;
        this.fPainter.uninstall();
        if (!this.fScrollable.isDisposed()) {
            this.fScrollable.removeControlListener((ControlListener)this);
            this.fScrollable.removeKeyListener((KeyListener)this);
            this.fScrollable.removeMouseWheelListener((MouseWheelListener)this);
            this.fScrollable.removeDisposeListener((DisposeListener)this);
            this.fScrollable.removePaintListener((PaintListener)this.fPainter);
        }
        if (!this.fDisplay.isDisposed()) {
            this.fDisplay.removeFilter(3, (Listener)this);
            this.fDisplay.removeFilter(4, (Listener)this);
            this.fDisplay.removeFilter(5, (Listener)this);
            this.fDisplay.removeFilter(35, (Listener)this);
        }
        this.fHorizontalScrollHandler.uninstall(this, disposing);
        this.fVerticalScrollHandler.uninstall(this, disposing);
    }

    protected abstract IScrollBarPainter createPaintListener();

    private void setArrowCursor() {
        if (this.fOldCursor == null) {
            Display display = Display.getCurrent();
            this.fOldCursor = this.fScrollable.getCursor();
            Cursor arrowCursor = display.getSystemCursor(0);
            this.fScrollable.setCursor(arrowCursor);
        }
    }

    private void restoreCursor() {
        if (this.fOldCursor != null) {
            this.fOldCursor = null;
            this.fScrollable.setCursor(null);
        }
    }

    public void controlMoved(ControlEvent e) {
        this.setMouseNearScrollScrollBar(false, false);
    }

    public void controlResized(ControlEvent e) {
        this.setMouseNearScrollScrollBar(false, false);
        this.fPainter.redrawScrollBars();
    }

    public void handleEvent(Event event) {
        if (!(event.widget instanceof Control)) {
            return;
        }
        Control control = (Control)event.widget;
        Point displayPos = event.type == 35 ? new Point(event.x, event.y) : control.toDisplay(event.x, event.y);
        Point controlPos = this.fScrollable.toControl(displayPos);
        if (event.type == 35 || isWindowsOS && event.type == 3 && event.button != 1) {
            if (this.fHorizontalScrollHandler.mousePosOverScroll(this.fScrollable, controlPos) || this.fVerticalScrollHandler.mousePosOverScroll(this.fScrollable, controlPos)) {
                this.stopEventPropagation(event);
            }
        } else if (event.type == 3) {
            this.fLastHorizontalAndTopPixel = this.computeHorizontalAndTopPixel();
            if (event.widget == this.fScrollable) {
                Rectangle currClientArea = this.fScrollable.getClientArea();
                if (this.fHorizontalScrollHandler.startDragOnMouseDown(this.fScrollable, controlPos, this.fLastHorizontalAndTopPixel, currClientArea) || this.fVerticalScrollHandler.startDragOnMouseDown(this.fScrollable, controlPos, this.fLastHorizontalAndTopPixel, currClientArea)) {
                    this.stopEventPropagation(event);
                } else if (this.fHorizontalScrollHandler.scrollOnMouseDown(this.fScrollable, controlPos, currClientArea)) {
                    this.fScrollOnMouseDownTimer.start(controlPos, this.fHorizontalScrollHandler);
                    this.stopEventPropagation(event);
                } else if (this.fVerticalScrollHandler.scrollOnMouseDown(this.fScrollable, controlPos, currClientArea)) {
                    this.fScrollOnMouseDownTimer.start(controlPos, this.fVerticalScrollHandler);
                    this.stopEventPropagation(event);
                }
            }
            this.checkChangedHorizontalAndTopPixel();
        } else if (event.type == 4) {
            this.fScrollOnMouseDownTimer.stop();
            boolean handled = this.fHorizontalScrollHandler.stopDragOnMouseUp(this.fScrollable);
            this.checkChangedHorizontalAndTopPixel();
            if (handled |= this.fVerticalScrollHandler.stopDragOnMouseUp(this.fScrollable)) {
                this.stopEventPropagation(event);
            }
        } else if (event.type == 5) {
            if (!this.fHorizontalScrollHandler.isDragging() && !this.fVerticalScrollHandler.isDragging()) {
                boolean showVertical;
                Rectangle currClientArea = this.fScrollable.getClientArea();
                Rectangle proximityRectHorizontal = this.fHorizontalScrollHandler.computeProximityRect(currClientArea);
                Rectangle proximityRectVertical = this.fVerticalScrollHandler.computeProximityRect(currClientArea);
                boolean showHorizontal = proximityRectHorizontal != null && proximityRectHorizontal.contains(controlPos.x, controlPos.y) && currClientArea.width < this.fHorizontalScrollHandler.fScrollBar.getMaximum() - this.fHorizontalScrollHandler.fScrollBar.getMinimum();
                boolean bl = showVertical = proximityRectVertical != null && proximityRectVertical.contains(controlPos.x, controlPos.y) && currClientArea.height < this.fVerticalScrollHandler.fScrollBar.getMaximum() - this.fVerticalScrollHandler.fScrollBar.getMinimum();
                if (showVertical || showHorizontal) {
                    this.setMouseNearScrollScrollBar(showVertical, showHorizontal);
                    this.setArrowCursor();
                } else {
                    this.setMouseNearScrollScrollBar(false, false);
                    this.restoreCursor();
                }
            }
            if (this.fHorizontalScrollHandler.dragOnMouseMove(this.fScrollable, controlPos) || this.fVerticalScrollHandler.dragOnMouseMove(this.fScrollable, controlPos)) {
                this.stopEventPropagation(event);
                return;
            }
            this.checkChangedHorizontalAndTopPixel();
        }
    }

    private void stopEventPropagation(Event event) {
        event.type = 0;
        event.doit = false;
    }

    protected boolean setMouseNearScrollScrollBar(boolean mouseNearVerticalScroll, boolean mouseNearHorizontalScroll) {
        if (mouseNearVerticalScroll != this.fVerticalScrollHandler.getMouseNearScrollScrollBar() || mouseNearHorizontalScroll != this.fHorizontalScrollHandler.getMouseNearScrollScrollBar()) {
            this.fHorizontalScrollHandler.setCursorNearScroll(mouseNearHorizontalScroll);
            this.fVerticalScrollHandler.setCursorNearScroll(mouseNearVerticalScroll);
            this.fPainter.redrawScrollBars();
            return true;
        }
        return false;
    }

    protected void checkChangedHorizontalAndTopPixel() {
        Point newHorizontalAndTopPixel = this.computeHorizontalAndTopPixel();
        if (!newHorizontalAndTopPixel.equals((Object)this.fLastHorizontalAndTopPixel)) {
            this.fLastHorizontalAndTopPixel = newHorizontalAndTopPixel;
            this.fPainter.redrawScrollBars();
        }
    }

    protected abstract Point computeHorizontalAndTopPixel();

    public void setScrollBarThemed(boolean themed) {
        if (themed != this.getScrollBarThemed()) {
            this.fScrollBarSettings.setScrollBarThemed(themed);
            if (themed) {
                this.install();
            } else {
                this.uninstall(false);
            }
        }
    }

    public boolean getScrollBarThemed() {
        return this.fScrollBarSettings.getScrollBarThemed();
    }

    public void setScrollBarBackgroundColor(Color newColor) {
        this.fScrollBarSettings.setBackgroundColor(newColor);
        this.fPainter.redrawScrollBars();
    }

    public Color getScrollBarBackgroundColor() {
        return this.fScrollBarSettings.getBackgroundColor();
    }

    public void setScrollBarForegroundColor(Color newColor) {
        this.fScrollBarSettings.setForegroundColor(newColor);
        this.fPainter.redrawScrollBars();
    }

    public Color getScrollBarForegroundColor() {
        return this.fScrollBarSettings.getForegroundColor();
    }

    public void setScrollBarWidth(int width) {
        this.fScrollBarSettings.setScrollBarWidth(width);
        this.fPainter.redrawScrollBars();
    }

    public int getScrollBarWidth() {
        return this.fScrollBarSettings.getScrollBarWidth();
    }

    public void setMouseNearScrollScrollBarWidth(int width) {
        this.fScrollBarSettings.setMouseNearScrollScrollBarWidth(width);
        this.fPainter.redrawScrollBars();
    }

    public int getMouseNearScrollScrollBarWidth() {
        return this.fScrollBarSettings.getMouseNearScrollScrollBarWidth();
    }

    public void setVerticalScrollBarVisible(boolean visible) {
        this.fVerticalScrollHandler.setVisible(visible);
    }

    public void setHorizontalScrollBarVisible(boolean visible) {
        this.fHorizontalScrollHandler.setVisible(visible);
    }

    public boolean getVerticalScrollBarVisible() {
        return this.fVerticalScrollHandler.getVisible();
    }

    public boolean getHorizontalScrollBarVisible() {
        return this.fHorizontalScrollHandler.getVisible();
    }

    public void setScrollBarBorderRadius(int radius) {
        this.fScrollBarSettings.setScrollBarBorderRadius(radius);
        this.fPainter.redrawScrollBars();
    }

    public int getScrollBarBorderRadius() {
        return this.fScrollBarSettings.getScrollBarBorderRadius();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.uninstall(true);
    }

    public void keyPressed(KeyEvent e) {
        this.checkChangedHorizontalAndTopPixel();
    }

    public void keyReleased(KeyEvent e) {
        this.checkChangedHorizontalAndTopPixel();
    }

    public void mouseScrolled(MouseEvent e) {
        this.checkChangedHorizontalAndTopPixel();
    }

    public void widgetSelected(SelectionEvent e) {
        this.checkChangedHorizontalAndTopPixel();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public static interface IScrollBarPainter
    extends PaintListener {
        public void redrawScrollBars();

        public void install(Scrollable var1);

        public void uninstall();
    }

    public static class ScrollBarSettings
    implements IScrollBarSettings {
        private Color fScrollForegroundColor;
        private Color fScrollBackgroundColor;
        private int fScrollBarWidth = 6;
        private int fMouseNearScrollScrollBarWidth = 15;
        private int fScrollBarBorderRadius;
        private boolean fScrollBarThemed;

        @Override
        public void setScrollBarThemed(boolean themed) {
            this.fScrollBarThemed = themed;
        }

        @Override
        public boolean getScrollBarThemed() {
            return this.fScrollBarThemed;
        }

        @Override
        public void setBackgroundColor(Color newColor) {
            this.fScrollBackgroundColor = newColor;
        }

        @Override
        public void setForegroundColor(Color newColor) {
            this.fScrollForegroundColor = newColor;
        }

        @Override
        public Color getForegroundColor() {
            if (this.fScrollForegroundColor != null && this.fScrollForegroundColor.isDisposed()) {
                this.fScrollForegroundColor = null;
            }
            return this.fScrollForegroundColor;
        }

        @Override
        public Color getBackgroundColor() {
            if (this.fScrollBackgroundColor != null && this.fScrollBackgroundColor.isDisposed()) {
                this.fScrollBackgroundColor = null;
            }
            return this.fScrollBackgroundColor;
        }

        @Override
        public void setScrollBarWidth(int width) {
            if (width < 1) {
                width = 1;
            }
            this.fScrollBarWidth = width;
        }

        @Override
        public int getScrollBarWidth() {
            return this.fScrollBarWidth;
        }

        @Override
        public void setMouseNearScrollScrollBarWidth(int width) {
            if (width < 1) {
                width = 1;
            }
            this.fMouseNearScrollScrollBarWidth = width;
        }

        @Override
        public int getMouseNearScrollScrollBarWidth() {
            return this.fMouseNearScrollScrollBarWidth;
        }

        @Override
        public void setScrollBarBorderRadius(int radius) {
            if (radius < 0) {
                radius = 0;
            }
            this.fScrollBarBorderRadius = radius;
        }

        @Override
        public int getScrollBarBorderRadius() {
            return this.fScrollBarBorderRadius;
        }
    }

    private static class ScrollOnMouseDownRunnable
    implements Runnable {
        private final Scrollable fScrollable;
        private final Display fDisplay;
        private AbstractScrollHandler fTargetScrollHandler;
        private Point fControlPos;

        public ScrollOnMouseDownRunnable(Scrollable scrollable, Display display) {
            this.fScrollable = scrollable;
            this.fDisplay = display;
        }

        @Override
        public void run() {
            if (this.fControlPos == null || this.fScrollable.isDisposed() || this.fDisplay.isDisposed()) {
                return;
            }
            Point cursorLocation = this.fDisplay.getCursorLocation();
            Point point = this.fScrollable.toControl(cursorLocation);
            Rectangle currClientArea = this.fScrollable.getClientArea();
            this.fTargetScrollHandler.scrollOnMouseDown(this.fScrollable, point, currClientArea);
            this.fDisplay.timerExec(50, (Runnable)this);
        }

        public void start(Point controlPos, AbstractScrollHandler targetScrollHandler) {
            this.fControlPos = controlPos;
            this.fTargetScrollHandler = targetScrollHandler;
            if (controlPos != null && targetScrollHandler != null) {
                this.fDisplay.timerExec(200, (Runnable)this);
            }
        }

        public void stop() {
            this.fControlPos = null;
        }
    }
}

