/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.preferences.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.preferences.PrefData;
import org.eclipse.rcptt.preferences.PrefNode;
import org.eclipse.rcptt.preferences.StringPrefData;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class PreferencesAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{IPropertySource.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IPropertySource.class && adaptableObject instanceof PrefNode) {
            return new PrefNodePropertySource((PrefNode)adaptableObject);
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    private class PrefNodePropertySource
    implements IPropertySource {
        private final PrefNode prefNode;
        private IPropertyDescriptor[] descriptorsCache;
        private Map<String, PrefData> dataCache;

        public PrefNodePropertySource(PrefNode prefNode) {
            this.prefNode = prefNode;
        }

        public Object getEditableValue() {
            return null;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            EList datas = this.prefNode.getData();
            if (datas.size() > 0) {
                if (this.descriptorsCache == null) {
                    this.initializeCaches();
                }
                return this.descriptorsCache;
            }
            return new IPropertyDescriptor[0];
        }

        public Object getPropertyValue(Object id) {
            PrefData data = this.getPrefData(id);
            if (data != null) {
                return ((StringPrefData)data).getValue();
            }
            return null;
        }

        public void setPropertyValue(Object id, Object value) {
            PrefData data = this.getPrefData(id);
            if (data != null && data instanceof StringPrefData) {
                ((StringPrefData)data).setValue((String)value);
            }
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        private PrefData getPrefData(Object key) {
            return this.dataCache.get(key);
        }

        private void initializeCaches() {
            EList datas = this.prefNode.getData();
            int len = datas.size();
            this.descriptorsCache = new IPropertyDescriptor[len];
            this.dataCache = new HashMap<String, PrefData>();
            int i = 0;
            while (i < len) {
                PrefData data = (PrefData)datas.get(i);
                if (data instanceof StringPrefData) {
                    this.descriptorsCache[i] = new TextPropertyDescriptor((Object)data.getKey(), data.getKey());
                    this.dataCache.put(data.getKey(), data);
                }
                ++i;
            }
        }
    }
}

