/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import org.eclipse.ui.internal.intro.impl.model.AbstractBaseIntroElement;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IntroText
extends AbstractBaseIntroElement {
    protected static final String TAG_TEXT = "text";
    private String text;
    private boolean isFormatted = false;

    IntroText(Element element, Bundle bundle) {
        super(element, bundle);
        Node textNode = element.getFirstChild();
        if (textNode == null) {
            return;
        }
        if (textNode.getNodeType() == 3 || textNode.getNodeType() == 4) {
            this.text = textNode.getNodeValue();
            this.isFormatted = this.checkIfFormatted();
        }
    }

    public String getText() {
        IntroModelRoot root = this.getModelRoot();
        if (root != null) {
            return root.resolveVariables(this.text);
        }
        return this.text;
    }

    @Override
    public int getType() {
        return 512;
    }

    public boolean checkIfFormatted() {
        if (this.text == null) {
            return false;
        }
        int i = this.text.indexOf("<");
        return i != -1;
    }

    public boolean isFormatted() {
        return this.isFormatted;
    }
}

