/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.target;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.PDELocationUtils;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.launching.internal.target.PDEHelper;
import org.eclipse.rcptt.launching.internal.target.TargetPlatformHelper;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.osgi.framework.Version;

public class TargetPlatformManager {
    private static void throwOnError(IStatus status) throws CoreException {
        if (status.matches(4)) {
            throw new CoreException(status);
        }
        if (!status.isOK()) {
            Q7ExtLaunchingPlugin.log(status);
        }
    }

    public static ITargetPlatformHelper createTargetPlatform(String location, IProgressMonitor monitor) throws CoreException {
        boolean isOk = false;
        ITargetPlatformService service = PDEHelper.getTargetService();
        ITargetDefinition target = service.newTarget();
        TargetPlatformHelper info = new TargetPlatformHelper(target);
        try {
            File productDir = PDELocationUtils.getProductLocation(location);
            ArrayList<ITargetLocation> containers = new ArrayList<ITargetLocation>();
            ITargetLocation installationContainer = service.newProfileLocation(productDir.getAbsolutePath(), null);
            info.getQ7Target().setInstall(installationContainer);
            containers.add(installationContainer);
            File pluginsDir = PDELocationUtils.getPluginFolder(location);
            ITargetLocation pluginsContainer = service.newDirectoryLocation(pluginsDir.getAbsolutePath());
            containers.add(pluginsContainer);
            info.getQ7Target().pluginsDir = pluginsContainer;
            info.setBundleContainers(containers.toArray(new ITargetLocation[containers.size()]));
            TargetPlatformManager.throwOnError(info.resolve(monitor));
            isOk = true;
            TargetPlatformHelper targetPlatformHelper = info;
            return targetPlatformHelper;
        }
        catch (StackOverflowError e) {
            throw TargetPlatformManager.createErrorProductLocationException(location, e);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching.ext", e.getMessage(), e));
        }
        finally {
            if (!isOk) {
                info.delete();
            }
        }
    }

    public static ITargetPlatformHelper findTarget(String requiredName, IProgressMonitor monitorArg, boolean needResolve) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)monitorArg);
        monitor.beginTask("Looking up " + requiredName, 2);
        try {
            ITargetHandle[] targets;
            ITargetHandle[] iTargetHandleArray = targets = PDEHelper.getTargetService().getTargets((IProgressMonitor)monitor.newChild(1));
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetHandle handle = iTargetHandleArray[n2];
                if (monitor.isCanceled()) {
                    return null;
                }
                ITargetDefinition def = TargetPlatformManager.getTargetDefinition(handle);
                String name = def.getName();
                if (name != null && name.equals(requiredName)) {
                    IStatus status;
                    TargetPlatformHelper info = new TargetPlatformHelper(def);
                    if (needResolve && !(status = info.resolve((IProgressMonitor)monitor.newChild(1, 0))).isOK()) {
                        LaunchingPlugin.log((IStatus)status);
                        info.delete();
                        return null;
                    }
                    TargetPlatformHelper targetPlatformHelper = info;
                    return targetPlatformHelper;
                }
                ++n2;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    public static void deleteTargetPlatform(String tName) {
        try {
            ITargetPlatformService service = PDEHelper.getTargetService();
            ITargetHandle[] handles = service.getTargets((IProgressMonitor)new NullProgressMonitor());
            ArrayList<ITargetHandle> toRemove = new ArrayList<ITargetHandle>();
            ITargetHandle[] iTargetHandleArray = handles;
            int n = handles.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetDefinition def;
                ITargetHandle iTargetHandle = iTargetHandleArray[n2];
                if (iTargetHandle.exists() && (def = TargetPlatformManager.getTargetDefinition(iTargetHandle)) != null && def.getName() != null && def.getName().equals(tName)) {
                    toRemove.add(iTargetHandle);
                }
                ++n2;
            }
            for (ITargetHandle iTargetHandle : toRemove) {
                service.deleteTarget(iTargetHandle);
            }
        }
        catch (CoreException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
    }

    public static void clearTargets() {
        ITargetPlatformService targetService = PDEHelper.getTargetService();
        TargetPlatformService s = (TargetPlatformService)targetService;
        Version version = RcpttCore.getPlatformVersion();
        if (version.getMajor() == 3 && version.getMinor() == 6) {
            try {
                Method method = TargetPlatformService.class.getDeclaredMethod("cleanOrphanedTargetDefinitionProfiles", new Class[0]);
                method.invoke((Object)s, new Object[0]);
                method = TargetPlatformService.class.getDeclaredMethod("garbageCollect", new Class[0]);
                method.invoke((Object)s, new Object[0]);
            }
            catch (Throwable e) {
                RcpttPlugin.log((Throwable)e);
            }
        } else if (version.getMajor() == 3 && version.getMinor() == 7) {
            try {
                P2TargetUtils.cleanOrphanedTargetDefinitionProfiles();
                P2TargetUtils.garbageCollect();
            }
            catch (Throwable e) {
                RcpttPlugin.log((Throwable)e);
            }
        }
    }

    private static ITargetDefinition getTargetDefinition(ITargetHandle handle) {
        block3: {
            try {
                if (handle != null) break block3;
                return null;
            }
            catch (CoreException e) {
                Q7ExtLaunchingPlugin.logWarn(e, "Error loading target definition of %s handle (%s)", handle.getClass().getName(), handle.toString());
                return null;
            }
        }
        return handle.getTargetDefinition();
    }

    public static ITargetPlatformHelper getCurrentTargetPlatform() {
        ITargetPlatformService targetService = PDEHelper.getTargetService();
        TargetPlatformService s = (TargetPlatformService)targetService;
        try {
            TargetPlatformHelper helper;
            ITargetHandle handle = s.getWorkspaceTargetHandle();
            if (handle != null && (helper = new TargetPlatformHelper(TargetPlatformManager.getTargetDefinition(handle)){

                @Override
                public IStatus resolve(IProgressMonitor monitor) {
                    return Status.OK_STATUS;
                }
            }).getStatus().isOK() && helper.getTargetPlatformProfilePath() != null) {
                return helper;
            }
            ITargetDefinition selfAUT = s.newDefaultTarget();
            selfAUT.setName("selfAUT_" + System.currentTimeMillis());
            s.saveTargetDefinition(selfAUT);
            TargetPlatformHelper helper2 = new TargetPlatformHelper(selfAUT){

                @Override
                public IStatus resolve(IProgressMonitor monitor) {
                    return Status.OK_STATUS;
                }
            };
            return helper2;
        }
        catch (CoreException e) {
            RcpttPlugin.log((Throwable)e);
            return null;
        }
    }

    public static TargetPlatformHelper getCurrentTargetPlatformCopy(String copyName) {
        block3: {
            ITargetDefinition targetSource;
            ITargetDefinition targetCopy;
            TargetPlatformService s;
            block4: {
                ITargetPlatformService targetService = PDEHelper.getTargetService();
                s = (TargetPlatformService)targetService;
                ITargetHandle handle = s.getWorkspaceTargetHandle();
                if (handle == null) break block3;
                targetCopy = s.newTarget();
                targetSource = TargetPlatformManager.getTargetDefinition(handle);
                if (targetSource != null) break block4;
                return null;
            }
            try {
                s.copyTargetDefinition(targetSource, targetCopy);
                targetCopy.setName(copyName);
                TargetPlatformHelper helper = new TargetPlatformHelper(targetCopy);
                return helper;
            }
            catch (CoreException e) {
                RcpttPlugin.log((Throwable)e);
            }
        }
        return null;
    }

    private static CoreException createErrorProductLocationException(String location, Throwable e) throws CoreException {
        return new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching.ext", String.format("Invalid eclipse product location: %s", location), e));
    }
}

