/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.wizards.toc;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ua.core.toc.text.TocDocumentFactory;
import org.eclipse.pde.internal.ua.core.toc.text.TocModel;
import org.eclipse.pde.internal.ua.core.toc.text.TocObject;
import org.eclipse.pde.internal.ua.core.toc.text.TocTopic;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.wizards.toc.TocWizardMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

public class TocOperation
extends WorkspaceModifyOperation {
    private IFile fFile;
    private String fTocName;

    public TocOperation(IFile file, String tocName) {
        this.fFile = file;
        this.fTocName = tocName;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        TocModel model = new TocModel((IDocument)CoreUtility.getTextDocument((InputStream)this.fFile.getContents()), false);
        model.setUnderlyingResource((IResource)this.fFile);
        this.initializeToc(model);
        model.save();
        model.dispose();
        this.openFile();
        monitor.done();
    }

    private void initializeToc(TocModel model) {
        TocTopic topic = this.createTopic(model);
        model.getToc().addChild((TocObject)topic);
        model.getToc().setFieldLabel(this.fTocName);
    }

    private TocTopic createTopic(TocModel model) {
        TocDocumentFactory factory = model.getFactory();
        TocTopic topic = factory.createTocTopic();
        topic.setFieldLabel(TocWizardMessages.TocOperation_topic);
        return topic;
    }

    protected void openFile() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow ww = PDEUserAssistanceUIPlugin.getActiveWorkbenchWindow();
                if (ww == null) {
                    return;
                }
                IWorkbenchPage page = ww.getActivePage();
                if (page == null || !TocOperation.this.fFile.exists()) {
                    return;
                }
                IWorkbenchPart focusPart = page.getActivePart();
                if (focusPart instanceof ISetSelectionTarget) {
                    StructuredSelection selection = new StructuredSelection((Object)TocOperation.this.fFile);
                    ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                }
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)TocOperation.this.fFile, (String)"org.eclipse.pde.ua.ui.tocEditor");
                }
                catch (PartInitException partInitException) {}
            }
        });
    }
}

