/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.monitoring.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.monitoring.MonitoringPlugin;
import org.eclipse.ui.internal.monitoring.preferences.FilterListEditor;
import org.eclipse.ui.internal.monitoring.preferences.Messages;

public class MonitoringPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int HOUR_IN_MS = 3600000;
    private static final IPreferenceStore preferences = MonitoringPlugin.getDefault().getPreferenceStore();
    private BooleanFieldEditor monitoringEnabled;
    private IntegerEditor longEventWarningThreshold;
    private IntegerEditor longEventErrorThreshold;
    private IntegerEditor deadlockThreshold;
    private Map<FieldEditor, Composite> editors = new HashMap<FieldEditor, Composite>();

    public MonitoringPreferencePage() {
        super(1);
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Composite container = new Composite(parent, 0);
        this.createTopBlock(container);
        this.createBottomBlock(container, pixelConverter);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(LayoutConstants.getSpacing()).generateLayout(container);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(LayoutConstants.getSpacing()).generateLayout(parent);
    }

    private Composite createTopBlock(Composite container) {
        Composite block = new Composite(container, 0);
        this.monitoringEnabled = this.createBooleanEditor("monitoring_enabled", Messages.MonitoringPreferencePage_enable_monitoring_label, block);
        this.createBooleanEditor("log_to_error_log", Messages.MonitoringPreferencePage_log_freeze_events_label, block);
        this.longEventWarningThreshold = this.createIntegerEditor("long_event_warning_threshold", Messages.MonitoringPreferencePage_warning_threshold_label, block, 3, 3600000);
        this.longEventErrorThreshold = this.createIntegerEditor("long_event_error_threshold", Messages.MonitoringPreferencePage_error_threshold_label, block, 3, 3600000);
        this.deadlockThreshold = this.createIntegerEditor("deadlock_reporting_threshold", Messages.MonitoringPreferencePage_deadlock_threshold_label, block, 1000, 86400000);
        this.createIntegerEditor("max_stack_samples", Messages.MonitoringPreferencePage_max_stack_samples_label, block, 0, 100);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(LayoutConstants.getSpacing()).applyTo(block);
        return block;
    }

    private Composite createBottomBlock(Composite container, PixelConverter pixelConverter) {
        Composite block = new Composite(container, 0);
        MonitoringPreferencePage.createEmptySpace(block, pixelConverter.convertVerticalDLUsToPixels(3), 2);
        FilterListEditor uiThreadFilter = new FilterListEditor("ui_thread_filter", Messages.MonitoringPreferencePage_ui_thread_filter_label, Messages.MonitoringPreferencePage_add_ui_thread_filter_button_label, Messages.MonitoringPreferencePage_remove_ui_thread_filter_button_label, Messages.FilterInputDialog_ui_thread_filter_message, block);
        this.addField(uiThreadFilter, block);
        MonitoringPreferencePage.createEmptySpace(block, pixelConverter.convertVerticalDLUsToPixels(3), 2);
        FilterListEditor noninterestingThreadFilter = new FilterListEditor("noninteresting_thread_filter", Messages.MonitoringPreferencePage_noninteresting_thread_filter_label, Messages.MonitoringPreferencePage_add_noninteresting_thread_filter_button_label, Messages.MonitoringPreferencePage_remove_noninteresting_thread_filter_button_label, Messages.FilterInputDialog_noninteresting_thread_filter_message, block);
        this.addField(noninterestingThreadFilter, block);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(LayoutConstants.getSpacing()).applyTo(block);
        return block;
    }

    private static Control createEmptySpace(Composite parent, int height, int span) {
        Label label = new Label(parent, 16384);
        GridDataFactory.fillDefaults().span(span, 1).hint(0, height).applyTo((Control)label);
        return label;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(preferences);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String preferenceName;
        Object source;
        if (event.getProperty().equals("field_editor_value") && (source = event.getSource()) instanceof FieldEditor && (preferenceName = ((FieldEditor)source).getPreferenceName()).equals("monitoring_enabled")) {
            boolean enabled = Boolean.TRUE.equals(event.getNewValue());
            this.enableDependentFields(enabled);
        }
        super.propertyChange(event);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.enableDependentFields(this.monitoringEnabled.getBooleanValue());
    }

    private void enableDependentFields(boolean enable) {
        for (Map.Entry<FieldEditor, Composite> entry : this.editors.entrySet()) {
            FieldEditor editor = entry.getKey();
            if (editor.getPreferenceName().equals("monitoring_enabled")) continue;
            editor.setEnabled(enable, entry.getValue());
        }
    }

    private BooleanFieldEditor createBooleanEditor(String name, String labelText, Composite parent) {
        BooleanFieldEditor field = new BooleanFieldEditor(name, labelText, parent);
        return this.addField(field, parent);
    }

    private IntegerEditor createIntegerEditor(String name, String labelText, Composite parent, int min, int max) {
        IntegerEditor field = new IntegerEditor(name, labelText, parent, min, max);
        return this.addField(field, parent);
    }

    private <T extends FieldEditor> T addField(T editor, Composite parent) {
        super.addField(editor);
        editor.fillIntoGrid(parent, 2);
        this.editors.put(editor, parent);
        if (!editor.getPreferenceName().equals("monitoring_enabled")) {
            boolean enabled = preferences.getBoolean("monitoring_enabled");
            editor.setEnabled(enabled, parent);
        }
        return editor;
    }

    private class IntegerEditor
    extends IntegerFieldEditor {
        public IntegerEditor(String name, String labelText, Composite parent, int min, int max) {
            super(name, labelText, parent);
            this.setValidRange(min, max);
        }

        protected void valueChanged() {
            super.valueChanged();
            if (MonitoringPreferencePage.this.longEventWarningThreshold.isValid() && MonitoringPreferencePage.this.longEventErrorThreshold.checkValue()) {
                MonitoringPreferencePage.this.deadlockThreshold.checkValue();
            }
        }

        protected boolean checkState() {
            if (!super.checkState()) {
                return false;
            }
            String preferenceName = this.getPreferenceName();
            if (preferenceName.equals("long_event_error_threshold")) {
                if (MonitoringPreferencePage.this.longEventWarningThreshold.isValid() && this.getIntValue() < MonitoringPreferencePage.this.longEventWarningThreshold.getIntValue()) {
                    this.showMessage(Messages.MonitoringPreferencePage_error_threshold_too_low_error);
                    return false;
                }
            } else if (preferenceName.equals("deadlock_reporting_threshold") && MonitoringPreferencePage.this.longEventWarningThreshold.isValid() && this.getIntValue() <= MonitoringPreferencePage.this.longEventErrorThreshold.getIntValue()) {
                this.showMessage(Messages.MonitoringPreferencePage_deadlock_threshold_too_low_error);
                return false;
            }
            return true;
        }

        private boolean checkValue() {
            boolean oldState = this.isValid();
            this.refreshValidState();
            boolean isValid = this.isValid();
            if (isValid != oldState) {
                this.fireStateChanged("field_editor_is_valid", oldState, isValid);
            }
            return isValid;
        }
    }
}

