/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.merge;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.variants.IResourceVariant;

class GitResourceVariantCache {
    private final Map<IResource, IResourceVariant> cache = new LinkedHashMap<IResource, IResourceVariant>();
    private final Map<IResource, Set<IResource>> members = new LinkedHashMap<IResource, Set<IResource>>();
    private final Set<IResource> roots = new LinkedHashSet<IResource>();

    GitResourceVariantCache() {
    }

    public void setVariant(IResource resource, IResourceVariant variant) {
        this.cache.put(resource, variant);
        IProject project = resource.getProject();
        if (project == null) {
            return;
        }
        this.roots.add((IResource)project);
        this.members.put(resource, new LinkedHashSet());
        IContainer parent = resource.getParent();
        Set<IResource> parentMembers = this.members.get(parent);
        if (parentMembers == null) {
            parentMembers = new LinkedHashSet<IResource>();
            this.members.put((IResource)parent, parentMembers);
        }
        parentMembers.add(resource);
    }

    public IResourceVariant getVariant(IResource resource) {
        return this.cache.get(resource);
    }

    public Set<IResource> getRoots() {
        return Collections.unmodifiableSet(this.roots);
    }

    public Set<IResource> getKnownResources() {
        return Collections.unmodifiableSet(this.cache.keySet());
    }

    public IResource[] members(IResource resource) {
        Set<IResource> children = this.members.get(resource);
        return children.toArray(new IResource[children.size()]);
    }
}

