/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

public class RenameResourceAction
extends SelectionDispatchAction {
    public RenameResourceAction(IWorkbenchSite site) {
        super(site);
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        IResource element = RenameResourceAction.getResource(selection);
        if (element == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(RefactoringAvailabilityTester.isRenameAvailable(element));
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        IResource resource = RenameResourceAction.getResource(selection);
        if (!RefactoringAvailabilityTester.isRenameAvailable(resource)) {
            return;
        }
        RefactoringExecutionStarter.startRenameResourceRefactoring(resource, this.getShell());
    }

    private static IResource getResource(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IResource)) {
            return null;
        }
        return (IResource)first;
    }
}

