/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.Util;

public class QuickFixPage
extends WizardPage {
    private Map<IMarkerResolution, Collection<IMarker>> resolutions;
    private TableViewer resolutionsList;
    private CheckboxTableViewer markersTable;
    private IWorkbenchPartSite site;
    private final IMarker[] selectedMarkers;

    public QuickFixPage(String problemDescription, IMarker[] selectedMarkers, Map<IMarkerResolution, Collection<IMarker>> resolutions, IWorkbenchPartSite site) {
        super(problemDescription);
        this.selectedMarkers = selectedMarkers;
        this.resolutions = resolutions;
        this.site = site;
        this.setTitle(MarkerMessages.resolveMarkerAction_dialogTitle);
        this.setMessage(problemDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, "org.eclipse.ui.problem_view_context");
        FormLayout layout = new FormLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.spacing = this.convertHorizontalDLUsToPixels(4);
        control.setLayout((Layout)layout);
        Label resolutionsLabel = new Label(control, 0);
        resolutionsLabel.setText(MarkerMessages.MarkerResolutionDialog_Resolutions_List_Title);
        resolutionsLabel.setLayoutData((Object)new FormData());
        this.createResolutionsList(control);
        FormData listData = new FormData();
        listData.top = new FormAttachment((Control)resolutionsLabel, 0);
        listData.left = new FormAttachment(0);
        listData.right = new FormAttachment(100, 0);
        listData.height = this.convertHeightInCharsToPixels(10);
        this.resolutionsList.getControl().setLayoutData((Object)listData);
        Label title = new Label(control, 0);
        title.setText(MarkerMessages.MarkerResolutionDialog_Problems_List_Title);
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(this.resolutionsList.getControl(), 0);
        labelData.left = new FormAttachment(0);
        title.setLayoutData((Object)labelData);
        this.createMarkerTable(control);
        Composite buttons = this.createTableButtons(control);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment((Control)title, 0);
        buttonData.right = new FormAttachment(100);
        buttonData.height = this.convertHeightInCharsToPixels(10);
        buttons.setLayoutData((Object)buttonData);
        FormData tableData = new FormData();
        tableData.top = new FormAttachment((Control)buttons, 0, 128);
        tableData.left = new FormAttachment(0);
        tableData.bottom = new FormAttachment(100);
        tableData.right = new FormAttachment((Control)buttons, 0);
        tableData.height = this.convertHeightInCharsToPixels(10);
        this.markersTable.getControl().setLayoutData((Object)tableData);
        Dialog.applyDialogFont((Control)control);
        this.resolutionsList.setSelection((ISelection)new StructuredSelection(this.resolutionsList.getElementAt(0)));
        this.markersTable.setCheckedElements((Object[])this.selectedMarkers);
        this.setPageComplete(this.markersTable.getCheckedElements().length > 0);
    }

    private Composite createTableButtons(Composite control) {
        Composite buttonComposite = new Composite(control, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        Button selectAll = new Button(buttonComposite, 8);
        selectAll.setText(MarkerMessages.selectAllAction_title);
        selectAll.setLayoutData((Object)new GridData(4, 0, false, false));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                QuickFixPage.this.markersTable.setAllChecked(true);
                QuickFixPage.this.setPageComplete(!QuickFixPage.this.resolutionsList.getSelection().isEmpty());
            }
        });
        Button deselectAll = new Button(buttonComposite, 8);
        deselectAll.setText(MarkerMessages.filtersDialog_deselectAll);
        deselectAll.setLayoutData((Object)new GridData(4, 0, false, false));
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                QuickFixPage.this.markersTable.setAllChecked(false);
                QuickFixPage.this.setPageComplete(false);
            }
        });
        return buttonComposite;
    }

    private void createResolutionsList(Composite control) {
        this.resolutionsList = new TableViewer(control, 2564);
        this.resolutionsList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return QuickFixPage.this.resolutions.keySet().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.resolutionsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IMarkerResolution)element).getLabel();
            }

            public Image getImage(Object element) {
                return element instanceof IMarkerResolution2 ? ((IMarkerResolution2)element).getImage() : null;
            }
        });
        this.resolutionsList.setInput((Object)this);
        this.resolutionsList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((IMarkerResolution)e1).getLabel().compareTo(((IMarkerResolution)e2).getLabel());
            }
        });
        this.resolutionsList.addSelectionChangedListener(event -> {
            this.markersTable.refresh();
            this.setPageComplete(this.markersTable.getCheckedElements().length > 0);
        });
    }

    private void createMarkerTable(Composite control) {
        this.markersTable = CheckboxTableViewer.newCheckList((Composite)control, (int)2564);
        this.createTableColumns();
        this.markersTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                IMarkerResolution selected = QuickFixPage.this.getSelectedResolution();
                if (selected == null) {
                    return new Object[0];
                }
                if (QuickFixPage.this.resolutions.containsKey(selected)) {
                    return ((Collection)QuickFixPage.this.resolutions.get(selected)).toArray();
                }
                return MarkerSupportInternalUtilities.EMPTY_MARKER_ARRAY;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.markersTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return Util.getImage(((IMarker)element).getAttribute("severity", -1));
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                IMarker marker = (IMarker)element;
                if (columnIndex == 0) {
                    return Util.getResourceName(marker);
                }
                String locationString = marker.getAttribute("location", "");
                if (locationString.length() > 0) {
                    return locationString;
                }
                int lineNumber = marker.getAttribute("lineNumber", -1);
                String lineNumberString = null;
                lineNumberString = lineNumber < 0 ? MarkerMessages.Unknown : NLS.bind((String)MarkerMessages.label_lineNumber, (Object)Integer.toString(lineNumber));
                return lineNumberString;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.markersTable.addCheckStateListener(event -> {
            if (event.getChecked()) {
                this.setPageComplete(true);
            } else {
                this.setPageComplete(this.markersTable.getCheckedElements().length > 0);
            }
        });
        new OpenAndLinkWithEditorHelper((StructuredViewer)this.markersTable){
            {
                this.setLinkWithEditor(false);
            }

            protected void activate(ISelection selection) {
                this.open(selection, true);
            }

            protected void linkToEditor(ISelection selection) {
            }

            protected void open(ISelection selection, boolean activate) {
                if (selection.isEmpty()) {
                    return;
                }
                IMarker marker = (IMarker)((IStructuredSelection)selection).getFirstElement();
                if (marker != null && marker.getResource() instanceof IFile) {
                    try {
                        IDE.openEditor(QuickFixPage.this.site.getPage(), marker, activate);
                    }
                    catch (PartInitException e) {
                        MarkerSupportInternalUtilities.showViewError((Exception)((Object)e));
                    }
                }
            }
        };
        this.markersTable.setInput((Object)this);
    }

    private void createTableColumns() {
        TableLayout layout = new TableLayout();
        Table table = this.markersTable.getTable();
        table.setLayout((Layout)layout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setText(MarkerMessages.MarkerResolutionDialog_Problems_List_Location);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        tc = new TableColumn(table, 0, 0);
        tc.setText(MarkerMessages.MarkerResolutionDialog_Problems_List_Resource);
    }

    public IMarker getSelectedMarker() {
        IStructuredSelection struct;
        ISelection selection = this.markersTable.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (struct = (IStructuredSelection)selection).size() == 1) {
            return (IMarker)struct.getFirstElement();
        }
        return null;
    }

    void performFinish(IProgressMonitor monitor) {
        IMarkerResolution resolution = this.getSelectedResolution();
        if (resolution == null) {
            return;
        }
        Object[] checked = this.markersTable.getCheckedElements();
        if (checked.length == 0) {
            return;
        }
        if (resolution instanceof WorkbenchMarkerResolution) {
            try {
                this.getWizard().getContainer().run(false, true, monitor1 -> {
                    IMarker[] markers = new IMarker[checked.length];
                    System.arraycopy(checked, 0, markers, 0, checked.length);
                    ((WorkbenchMarkerResolution)resolution).run(markers, monitor1);
                });
            }
            catch (InvocationTargetException e) {
                StatusManager.getManager().handle(MarkerSupportInternalUtilities.errorFor(e));
            }
            catch (InterruptedException e) {
                StatusManager.getManager().handle(MarkerSupportInternalUtilities.errorFor(e));
            }
        } else {
            try {
                this.getWizard().getContainer().run(false, true, monitor1 -> {
                    monitor1.beginTask(MarkerMessages.MarkerResolutionDialog_Fixing, checked.length);
                    int i = 0;
                    while (i < checked.length) {
                        this.getShell().getDisplay().readAndDispatch();
                        if (monitor1.isCanceled()) {
                            return;
                        }
                        IMarker marker = (IMarker)checked[i];
                        monitor1.subTask(Util.getProperty("message", marker));
                        resolution.run(marker);
                        monitor1.worked(1);
                        ++i;
                    }
                });
            }
            catch (InvocationTargetException e) {
                StatusManager.getManager().handle(MarkerSupportInternalUtilities.errorFor(e));
            }
            catch (InterruptedException e) {
                StatusManager.getManager().handle(MarkerSupportInternalUtilities.errorFor(e));
            }
        }
    }

    private IMarkerResolution getSelectedResolution() {
        ISelection selection = this.resolutionsList.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object first = ((IStructuredSelection)selection).getFirstElement();
        return (IMarkerResolution)first;
    }
}

