/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;

public abstract class AbstractSearchResultPage
extends AbstractTextSearchViewPage {
    private ContentProvider fContentProvider;

    public AbstractSearchResultPage() {
        super(1);
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null && this.fContentProvider.fSearchResult != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        throw new IllegalStateException("Doesn't support tree mode.");
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setComparator(this.createViewerComparator());
        viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.fContentProvider = new ContentProvider();
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
    }

    protected abstract ILabelProvider createLabelProvider();

    protected abstract ViewerComparator createViewerComparator();

    class ContentProvider
    implements IStructuredContentProvider {
        private TableViewer fTableViewer;
        private AbstractTextSearchResult fSearchResult;

        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof AbstractTextSearchResult) {
                return ((AbstractTextSearchResult)inputElement).getElements();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fTableViewer = (TableViewer)viewer;
            this.fSearchResult = (AbstractTextSearchResult)newInput;
        }

        public void clear() {
            this.fTableViewer.refresh();
        }

        public void elementsChanged(Object[] updatedElements) {
            int i = 0;
            while (i < updatedElements.length) {
                if (this.fSearchResult.getMatchCount(updatedElements[i]) > 0) {
                    if (this.fTableViewer.testFindItem(updatedElements[i]) != null) {
                        this.fTableViewer.refresh(updatedElements[i]);
                    } else {
                        this.fTableViewer.add(updatedElements[i]);
                    }
                } else {
                    this.fTableViewer.remove(updatedElements[i]);
                }
                ++i;
            }
        }
    }
}

