/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;

public final class DestinationContentProvider
extends StandardJavaElementContentProvider {
    private IReorgDestinationValidator fValidator;

    public DestinationContentProvider(IReorgDestinationValidator validator) {
        super(true);
        this.fValidator = validator;
    }

    @Override
    public boolean hasChildren(Object element) {
        IPackageFragmentRoot root;
        IJavaElement javaElement;
        IReorgDestination destination = ReorgDestinationFactory.createDestination(element);
        if (!this.fValidator.canChildrenBeDestinations(destination)) {
            return false;
        }
        if (element instanceof IJavaElement && (javaElement = (IJavaElement)element).getElementType() == 3 && ((root = (IPackageFragmentRoot)javaElement).isArchive() || root.isExternal())) {
            return false;
        }
        return super.hasChildren(element);
    }

    @Override
    public Object[] getChildren(Object element) {
        try {
            if (element instanceof IJavaModel) {
                return DestinationContentProvider.concatenate(this.getJavaProjects((IJavaModel)element), DestinationContentProvider.getOpenNonJavaProjects((IJavaModel)element));
            }
            Object[] children = this.doGetChildren(element);
            ArrayList<Object> result = new ArrayList<Object>(children.length);
            int i = 0;
            while (i < children.length) {
                IReorgDestination destination = ReorgDestinationFactory.createDestination(children[i]);
                if (this.fValidator.canElementBeDestination(destination) || this.fValidator.canChildrenBeDestinations(destination)) {
                    result.add(children[i]);
                }
                ++i;
            }
            return result.toArray();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new Object[0];
        }
    }

    private Object[] doGetChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            IContainer container = (IContainer)parentElement;
            return this.getResources(container);
        }
        return super.getChildren(parentElement);
    }

    private Object[] getResources(IContainer container) {
        try {
            Object[] members = container.members();
            IJavaProject javaProject = JavaCore.create((IProject)container.getProject());
            if (javaProject == null || !javaProject.exists()) {
                return members;
            }
            boolean isFolderOnClasspath = javaProject.isOnClasspath((IResource)container);
            ArrayList<Object> nonJavaResources = new ArrayList<Object>();
            int i = 0;
            while (i < members.length) {
                Object member = members[i];
                if (isFolderOnClasspath) {
                    if (javaProject.findPackageFragmentRoot(member.getFullPath()) == null) {
                        nonJavaResources.add(member);
                    }
                } else if (!javaProject.isOnClasspath((IResource)member)) {
                    nonJavaResources.add(member);
                }
                ++i;
            }
            return nonJavaResources.toArray();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    private static Object[] getOpenNonJavaProjects(IJavaModel model) throws JavaModelException {
        Object[] nonJavaProjects = model.getNonJavaResources();
        ArrayList<IProject> result = new ArrayList<IProject>(nonJavaProjects.length);
        int i = 0;
        while (i < nonJavaProjects.length) {
            IProject project = (IProject)nonJavaProjects[i];
            if (project.isOpen()) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray();
    }
}

