/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarManifestProvider;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerUtil;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarRsrcUrlBuilder;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;

public class FatJarRsrcUrlManifestProvider
extends FatJarManifestProvider {
    public FatJarRsrcUrlManifestProvider(FatJarRsrcUrlBuilder builder) {
        super(builder);
    }

    private void setManifestRsrcClasspath(Manifest ownManifest, JarPackageData jarPackage) {
        ArrayList<String> jarNames = new ArrayList<String>();
        Object[] elements = jarPackage.getElements();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)element).isArchive()) {
                String jarName = ((IPackageFragmentRoot)element).getPath().toFile().getName();
                while (jarNames.contains(jarName)) {
                    jarName = FatJarPackagerUtil.nextNumberedFileName(jarName);
                }
                jarNames.add(jarName);
            }
            ++i;
        }
        String manifestRsrcClasspath = this.getManifestRsrcClasspath(jarNames);
        ownManifest.getMainAttributes().putValue("Rsrc-Class-Path", manifestRsrcClasspath);
    }

    public String getManifestRsrcClasspath(ArrayList<String> jarNames) {
        StringBuffer result = new StringBuffer();
        result.append("./");
        for (String jarName : jarNames) {
            try {
                jarName = URLEncoder.encode(jarName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                JavaPlugin.log(e);
            }
            result.append(" ").append(jarName);
        }
        return result.toString();
    }

    @Override
    protected void putAdditionalEntries(Manifest manifest, JarPackageData jarPackage) {
        this.setManifestRsrcClasspath(manifest, jarPackage);
        this.putMainClass(manifest, jarPackage);
    }

    private void putMainClass(Manifest manifest, JarPackageData jarPackage) {
        if (jarPackage.getManifestMainClass() != null && jarPackage.getManifestMainClass().getFullyQualifiedName().length() > 0) {
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, "org.eclipse.jdt.internal.jarinjarloader.JarRsrcLoader");
            manifest.getMainAttributes().putValue("Rsrc-Main-Class", jarPackage.getManifestMainClass().getFullyQualifiedName());
        }
    }
}

