/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.migration;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.e4.migration.IModelBuilderFactory;
import org.eclipse.ui.internal.e4.migration.MementoSerializer;
import org.eclipse.ui.internal.e4.migration.PerspectiveReader;
import org.eclipse.ui.internal.e4.migration.WindowBuilder;
import org.eclipse.ui.internal.e4.migration.WindowReader;
import org.eclipse.ui.internal.e4.migration.WorkbenchMementoReader;

public class ApplicationBuilder {
    @Inject
    private MApplication application;
    @Inject
    private WorkbenchMementoReader reader;
    @Inject
    private IModelBuilderFactory builderFactory;
    @Inject
    @Preference(nodePath="org.eclipse.ui.workbench")
    private IEclipsePreferences preferences;
    private Map<String, String> minMaxPersistedState;

    void createApplication() {
        List windows = this.application.getChildren();
        for (WindowReader windowReader : this.reader.getWindowReaders()) {
            Object list;
            WindowBuilder windowBuilder = this.builderFactory.createWindowBuilder(windowReader);
            MWindow window = windowBuilder.createWindow();
            windows.add(window);
            if (windowBuilder.isSelected()) {
                this.application.setSelectedElement((MUIElement)window);
            }
            if (!((list = window.getTransientData().remove(WindowBuilder.PERSPECTIVES)) instanceof List)) continue;
            List perspectiveList = (List)list;
            for (MPerspective perspective : perspectiveList) {
                this.importToolbarsLocation(perspective);
            }
        }
        this.addClosedPerspectives();
        this.addMRU();
    }

    private void addClosedPerspectives() {
        String perspProp = this.preferences.get("perspectives", null);
        if (perspProp == null) {
            return;
        }
        List snippets = this.application.getSnippets();
        String[] stringArray = perspProp.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String perspName = stringArray[n2];
            XMLMemento memento = null;
            try {
                memento = XMLMemento.createReadRoot(new StringReader(this.preferences.get(String.valueOf(perspName) + "_persp", "")));
            }
            catch (WorkbenchException e) {
                WorkbenchPlugin.log("Loading custom perspective failed: " + perspName, (Throwable)((Object)e));
            }
            snippets.add(this.builderFactory.createPerspectiveBuilder(new PerspectiveReader(memento)).createPerspective());
            ++n2;
        }
    }

    private void addMRU() {
        this.application.getPersistedState().put(Workbench.MEMENTO_KEY, new MementoSerializer(this.reader.getMruMemento()).serialize());
    }

    private void importToolbarsLocation(MPerspective persp) {
        String trimsData = (String)persp.getPersistedState().get("trims");
        if (trimsData == null || trimsData.trim().isEmpty()) {
            return;
        }
        persp.getPersistedState().remove("trims");
        Map<String, String> minMaxPersState = this.getMinMaxPersistedState();
        if (minMaxPersState == null) {
            return;
        }
        minMaxPersState.put(persp.getElementId(), trimsData);
    }

    private Map<String, String> getMinMaxPersistedState() {
        if (this.minMaxPersistedState != null) {
            return this.minMaxPersistedState;
        }
        for (MAddon addon : this.application.getAddons()) {
            if (!"MinMax Addon".equals(addon.getElementId())) continue;
            this.minMaxPersistedState = addon.getPersistedState();
            break;
        }
        return this.minMaxPersistedState;
    }
}

