/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.actions.SortAction;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.feature.OpenReferenceAction;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class IncludedFeaturesSection
extends TableSection
implements IFeatureModelListener,
IPropertyChangeListener {
    private static final int NEW = 0;
    private static final int REMOVE = 1;
    private static final int UP = 2;
    private static final int DOWN = 3;
    private TableViewer fIncludesViewer;
    private Action fNewAction;
    private Action fOpenAction;
    private Action fDeleteAction;
    private SortAction fSortAction;

    public IncludedFeaturesSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.FeatureEditor_IncludedFeatures_new, PDEUIMessages.FeatureEditor_IncludedFeatures_remove, PDEUIMessages.FeatureEditor_IncludedFeatures_up, PDEUIMessages.FeatureEditor_IncludedFeatures_down});
        this.getSection().setText(PDEUIMessages.FeatureEditor_IncludedFeatures_title);
        this.getSection().setDescription(PDEUIMessages.FeatureEditor_IncludedFeatures_desc);
        this.getTablePart().setEditable(false);
        this.getSection().setLayoutData((Object)new GridData(1808));
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fIncludesViewer = tablePart.getTableViewer();
        this.fIncludesViewer.setContentProvider((IContentProvider)new IncludedFeaturesContentProvider());
        this.fIncludesViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fIncludesViewer.setComparator(ListUtil.NAME_COMPARATOR);
        toolkit.paintBordersFor(container);
        this.makeActions();
        section.setClient((Control)container);
        this.initialize();
        this.createSectionToolbar(section, toolkit);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        Cursor handCursor = Display.getCurrent().getSystemCursor(21);
        toolbar.setCursor(handCursor);
        this.fSortAction = new SortAction(this.getStructuredViewerPart().getViewer(), PDEUIMessages.FeatureEditor_IncludedFeatures_sortAlpha, ListUtil.NAME_COMPARATOR, null, this);
        toolBarManager.add((IAction)this.fSortAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
        this.fOpenAction.run();
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
                break;
            }
            case 1: {
                this.handleDelete();
                break;
            }
            case 2: {
                this.handleUp();
                break;
            }
            case 3: {
                this.handleDown();
            }
        }
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        FeatureModelManager mng = PDECore.getDefault().getFeatureModelManager();
        mng.removeFeatureModelListener((IFeatureModelListener)this);
        super.dispose();
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IFeatureChild) {
            this.fIncludesViewer.setSelection((ISelection)new StructuredSelection(object), true);
            return true;
        }
        return false;
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fOpenAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fNewAction);
        manager.add((IAction)this.fDeleteAction);
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleUp() {
        int index = this.getTablePart().getTableViewer().getTable().getSelectionIndex();
        if (index < 1) {
            return;
        }
        this.swap(index, index - 1);
    }

    private void handleDown() {
        Table table = this.getTablePart().getTableViewer().getTable();
        int index = table.getSelectionIndex();
        if (index == table.getItemCount() - 1) {
            return;
        }
        this.swap(index, index + 1);
    }

    private void handleNew() {
        BusyIndicator.showWhile((Display)this.fIncludesViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IFeatureModel[] allModels = PDECore.getDefault().getFeatureModelManager().getModels();
                ArrayList<IFeatureModel> newModels = new ArrayList<IFeatureModel>();
                int i = 0;
                while (i < allModels.length) {
                    if (IncludedFeaturesSection.this.canAdd(allModels[i])) {
                        newModels.add(allModels[i]);
                    }
                    ++i;
                }
                IFeatureModel[] candidateModels = newModels.toArray(new IFeatureModel[newModels.size()]);
                FeatureSelectionDialog dialog = new FeatureSelectionDialog(IncludedFeaturesSection.this.fIncludesViewer.getTable().getShell(), candidateModels, true);
                if (dialog.open() == 0) {
                    Object[] models = dialog.getResult();
                    try {
                        IncludedFeaturesSection.this.doAdd(models);
                    }
                    catch (CoreException e) {
                        PDEPlugin.log(e);
                    }
                }
            }
        });
    }

    public void swap(int index1, int index2) {
        Table table = this.getTablePart().getTableViewer().getTable();
        IFeatureChild feature1 = (IFeatureChild)table.getItem(index1).getData();
        IFeatureChild feature2 = (IFeatureChild)table.getItem(index2).getData();
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        feature.swap(feature1, feature2);
    }

    private void doAdd(Object[] candidates) throws CoreException {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        IFeatureChild[] added = new IFeatureChild[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IFeatureModel candidate = (IFeatureModel)candidates[i];
            FeatureChild child = (FeatureChild)model.getFactory().createChild();
            child.loadFrom(candidate.getFeature());
            child.setVersion("0.0.0");
            added[i] = child;
            ++i;
        }
        feature.addIncludedFeatures(added);
    }

    private boolean canAdd(IFeatureModel candidate) {
        IFeature cfeature = candidate.getFeature();
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        if (cfeature.getId().equals(feature.getId()) && cfeature.getVersion().equals(feature.getVersion())) {
            return false;
        }
        boolean isPatchEditor = ((FeatureEditor)this.getPage().getEditor()).isPatchEditor();
        if (isPatchEditor && !IncludedFeaturesSection.isFeaturePatch(candidate.getFeature())) {
            return false;
        }
        IFeatureChild[] features = feature.getIncludedFeatures();
        int i = 0;
        while (i < features.length) {
            if (features[i].getId().equals(cfeature.getId()) && features[i].getVersion().equals(cfeature.getVersion())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isFeaturePatch(IFeature feature) {
        IFeatureImport[] imports = feature.getImports();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void handleSelectAll() {
        IStructuredContentProvider provider = (IStructuredContentProvider)this.fIncludesViewer.getContentProvider();
        Object[] elements = provider.getElements(this.fIncludesViewer.getInput());
        StructuredSelection ssel = new StructuredSelection(elements);
        this.fIncludesViewer.setSelection((ISelection)ssel);
    }

    private void handleDelete() {
        IStructuredSelection ssel = (IStructuredSelection)this.fIncludesViewer.getSelection();
        if (ssel.isEmpty()) {
            return;
        }
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (!model.isEditable()) {
            return;
        }
        IFeature feature = model.getFeature();
        try {
            IFeatureChild[] removed = new IFeatureChild[ssel.size()];
            int i = 0;
            for (IFeatureChild iobj : ssel) {
                removed[i++] = iobj;
            }
            feature.removeIncludedFeatures(removed);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            BusyIndicator.showWhile((Display)this.fIncludesViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    IncludedFeaturesSection.this.handleDelete();
                }
            });
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            BusyIndicator.showWhile((Display)this.fIncludesViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    IncludedFeaturesSection.this.handleSelectAll();
                }
            });
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        this.getTablePart().setButtonEnabled(0, model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
        FeatureModelManager mng = PDECore.getDefault().getFeatureModelManager();
        mng.addFeatureModelListener((IFeatureModelListener)this);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object obj = e.getChangedObjects()[0];
        if (obj instanceof IFeatureChild) {
            if (e.getChangeType() == 3) {
                this.fIncludesViewer.refresh();
            } else if (e.getChangeType() == 1) {
                this.fIncludesViewer.add(e.getChangedObjects());
                if (e.getChangedObjects().length > 0) {
                    this.fIncludesViewer.setSelection((ISelection)new StructuredSelection(e.getChangedObjects()[0]));
                }
            } else if (e.getChangeType() == 2) {
                this.fIncludesViewer.remove(e.getChangedObjects());
            }
        }
    }

    private void makeActions() {
        IModel model = (IModel)this.getPage().getModel();
        this.fNewAction = new Action(){

            public void run() {
                IncludedFeaturesSection.this.handleNew();
            }
        };
        this.fNewAction.setText(PDEUIMessages.Menus_new_label);
        this.fNewAction.setEnabled(model.isEditable());
        this.fDeleteAction = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)IncludedFeaturesSection.this.fIncludesViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IncludedFeaturesSection.this.handleDelete();
                    }
                });
            }
        };
        this.fDeleteAction.setEnabled(model.isEditable());
        this.fDeleteAction.setText(PDEUIMessages.Actions_delete_label);
        this.fOpenAction = new OpenReferenceAction((ISelectionProvider)this.fIncludesViewer);
    }

    public void modelsChanged(final IFeatureModelDelta delta) {
        this.getSection().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (IncludedFeaturesSection.this.getSection().isDisposed()) {
                    return;
                }
                IFeatureModel[] added = delta.getAdded();
                IFeatureModel[] removed = delta.getRemoved();
                IFeatureModel[] changed = delta.getChanged();
                if (IncludedFeaturesSection.this.hasModels(added) || IncludedFeaturesSection.this.hasModels(removed) || IncludedFeaturesSection.this.hasModels(changed)) {
                    IncludedFeaturesSection.this.markStale();
                }
            }
        });
    }

    private boolean hasModels(IFeatureModel[] models) {
        if (models == null) {
            return false;
        }
        IFeatureModel thisModel = (IFeatureModel)this.getPage().getModel();
        if (thisModel == null) {
            return false;
        }
        int i = 0;
        while (i < models.length) {
            if (models[i] != thisModel) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setFocus() {
        if (this.fIncludesViewer != null) {
            this.fIncludesViewer.getTable().setFocus();
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.fIncludesViewer.setInput((Object)feature);
        this.updateButtons();
        super.refresh();
    }

    private void updateButtons() {
        EditableTablePart tablePart = this.getTablePart();
        Table table = tablePart.getTableViewer().getTable();
        TableItem[] tableSelection = table.getSelection();
        boolean hasSelection = tableSelection.length > 0;
        tablePart.setButtonEnabled(1, this.isEditable() && hasSelection);
        boolean canMove = table.getItemCount() > 1 && tableSelection.length == 1 && !this.fSortAction.isChecked();
        tablePart.setButtonEnabled(2, canMove && this.isEditable() && hasSelection && table.getSelectionIndex() > 0);
        tablePart.setButtonEnabled(3, canMove && hasSelection && this.isEditable() && table.getSelectionIndex() < table.getItemCount() - 1);
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Object[] objects = (Object[])clipboard.getContents((Transfer)ModelDataTransfer.getInstance());
        if (objects != null && objects.length > 0) {
            return this.canPaste(null, objects);
        }
        return false;
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (!(objects[i] instanceof FeatureChild)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void doPaste() {
        ModelDataTransfer modelTransfer;
        Clipboard clipboard = this.getPage().getPDEEditor().getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)(modelTransfer = ModelDataTransfer.getInstance()));
        if (objects != null) {
            this.doPaste(null, objects);
        }
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        if (!model.isEditable()) {
            return;
        }
        FeatureChild[] fChildren = new FeatureChild[objects.length];
        try {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof FeatureChild) {
                    FeatureChild fChild = (FeatureChild)objects[i];
                    fChild.setModel(model);
                    fChild.setParent((IFeatureObject)feature);
                    fChildren[i] = fChild;
                }
                ++i;
            }
            feature.addIncludedFeatures((IFeatureChild[])fChildren);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    void fireSelection() {
        ISelection sel = this.fIncludesViewer.getSelection();
        if (!sel.isEmpty()) {
            this.fIncludesViewer.setSelection(this.fIncludesViewer.getSelection());
        } else if (this.fIncludesViewer.getElementAt(0) != null) {
            this.fIncludesViewer.setSelection((ISelection)new StructuredSelection(this.fIncludesViewer.getElementAt(0)));
        }
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (((Object)((Object)this.fSortAction)).equals(event.getSource()) && "result".equals(event.getProperty())) {
            this.updateButtons();
        }
    }

    class IncludedFeaturesContentProvider
    implements IStructuredContentProvider {
        IncludedFeaturesContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IFeature) {
                return ((IFeature)parent).getIncludedFeatures();
            }
            return new Object[0];
        }
    }
}

