/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.StructuredViewerSection;
import org.eclipse.pde.internal.ui.parts.StructuredViewerPart;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class TreeSection
extends StructuredViewerSection {
    protected boolean fHandleDefaultButton = true;

    public TreeSection(PDEFormPage formPage, Composite parent, int style, String[] buttonLabels) {
        super(formPage, parent, style, buttonLabels);
    }

    @Override
    protected StructuredViewerPart createViewerPart(String[] buttonLabels) {
        return new PartAdapter(buttonLabels);
    }

    protected TreePart getTreePart() {
        return (TreePart)this.fViewerPart;
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        return new TreeViewer(parent, style);
    }

    protected void selectionChanged(IStructuredSelection selection) {
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        TreeViewer viewer = (TreeViewer)this.fViewerPart.getViewer();
        boolean expandedState = viewer.getExpandedState(selection.getFirstElement());
        viewer.setExpandedState(selection.getFirstElement(), !expandedState);
    }

    protected void enableButtons() {
    }

    class PartAdapter
    extends TreePart {
        public PartAdapter(String[] buttonLabels) {
            super(buttonLabels);
        }

        @Override
        public void selectionChanged(IStructuredSelection selection) {
            TreeSection.this.getManagedForm().fireSelectionChanged((IFormPart)TreeSection.this, (ISelection)selection);
            TreeSection.this.selectionChanged(selection);
        }

        @Override
        public void handleDoubleClick(IStructuredSelection selection) {
            TreeSection.this.handleDoubleClick(selection);
        }

        @Override
        public void buttonSelected(Button button, int index) {
            TreeSection.this.buttonSelected(index);
            if (TreeSection.this.fHandleDefaultButton) {
                button.getShell().setDefaultButton(null);
            }
        }

        @Override
        protected void createButtons(Composite parent, FormToolkit toolkit) {
            super.createButtons(parent, toolkit);
            TreeSection.this.enableButtons();
            if (parent.getData("filtered") != null) {
                GridLayout layout = (GridLayout)this.fButtonContainer.getLayout();
                layout.marginHeight = 28;
            }
        }

        @Override
        protected TreeViewer createTreeViewer(Composite parent, int style) {
            return TreeSection.this.createTreeViewer(parent, style);
        }
    }
}

