/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.refactoring.CuCollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;

public class TypeOccurrenceCollector
extends CuCollectingSearchRequestor {
    private final String fOldName;
    private final String fOldQualifiedName;

    public TypeOccurrenceCollector(IType type) {
        this(type, null);
    }

    public TypeOccurrenceCollector(IType type, ReferencesInBinaryContext binaryRefs) {
        super(binaryRefs);
        this.fOldName = type.getElementName();
        this.fOldQualifiedName = type.getFullyQualifiedName('.');
    }

    public void acceptSearchMatch(ICompilationUnit unit, SearchMatch match) throws CoreException {
        this.collectMatch(this.acceptSearchMatch2(unit, match));
    }

    public SearchMatch acceptSearchMatch2(ICompilationUnit unit, SearchMatch match) throws CoreException {
        int start = match.getOffset();
        int length = match.getLength();
        String matchText = unit.getBuffer().getText(start, length);
        if (this.fOldName.equals(matchText)) {
            return match;
        }
        if (this.fOldQualifiedName.endsWith(matchText)) {
            int simpleNameLenght = this.fOldName.length();
            match.setOffset(start + length - simpleNameLenght);
            match.setLength(simpleNameLenght);
            return match;
        }
        IScanner scanner = this.getScanner(unit);
        scanner.setSource(matchText.toCharArray());
        int simpleNameStart = -1;
        int simpleNameEnd = -1;
        try {
            int token = scanner.getNextToken();
            while (token != 158) {
                if (token == 5) {
                    simpleNameStart = scanner.getCurrentTokenStartPosition();
                    simpleNameEnd = scanner.getCurrentTokenEndPosition();
                }
                token = scanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {}
        if (simpleNameStart != -1) {
            match.setOffset(start + simpleNameStart);
            match.setLength(simpleNameEnd + 1 - simpleNameStart);
        }
        return match;
    }
}

