/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.SpecificContentAssistExecutor;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

final class SpecificContentAssistAction
extends Action
implements IUpdate {
    private final CompletionProposalCategory fCategory;
    private final SpecificContentAssistExecutor fExecutor = new SpecificContentAssistExecutor(CompletionProposalComputerRegistry.getDefault());
    private JavaEditor fEditor;

    public SpecificContentAssistAction(CompletionProposalCategory category) {
        this.fCategory = category;
        this.setText(category.getName());
        this.setImageDescriptor(category.getImageDescriptor());
        this.setActionDefinitionId("org.eclipse.jdt.ui.specific_content_assist.command");
    }

    public void run() {
        ITextEditor editor = this.getActiveEditor();
        if (editor == null) {
            return;
        }
        this.fExecutor.invokeContentAssist(editor, this.fCategory.getId());
    }

    private ITextEditor getActiveEditor() {
        return this.fEditor;
    }

    public void setActiveEditor(IEditorPart part) {
        JavaEditor editor = part instanceof JavaEditor ? (JavaEditor)part : null;
        this.fEditor = editor;
        this.setEnabled(this.computeEnablement((ITextEditor)this.fEditor));
    }

    private boolean computeEnablement(ITextEditor editor) {
        if (editor == null) {
            return false;
        }
        ITextOperationTarget target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        if (target == null || !target.canDoOperation(13)) {
            return false;
        }
        IJavaProject javaProject = EditorUtility.getJavaProject(editor.getEditorInput());
        if (!this.fCategory.matches(javaProject)) {
            return false;
        }
        ISelection selection = editor.getSelectionProvider().getSelection();
        return this.isValidSelection(selection);
    }

    private boolean isValidSelection(ISelection selection) {
        String contentType;
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        int offset = ((ITextSelection)selection).getOffset();
        IDocument document = this.getDocument();
        if (document == null) {
            return false;
        }
        try {
            contentType = TextUtilities.getContentType((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)true);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        return this.fCategory.hasComputers(contentType);
    }

    private IDocument getDocument() {
        Assert.isTrue((this.fEditor != null ? 1 : 0) != 0);
        IDocumentProvider provider = this.fEditor.getDocumentProvider();
        if (provider == null) {
            return null;
        }
        IDocument document = provider.getDocument((Object)this.fEditor.getEditorInput());
        return document;
    }

    public void update() {
        this.setEnabled(this.computeEnablement((ITextEditor)this.fEditor));
    }
}

