/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree.ui;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.rcptt.tesla.core.ui.Color;
import org.eclipse.rcptt.ui.utils.RangeUtils;
import org.eclipse.rcptt.util.swt.StyleRangeUtils;
import org.eclipse.rcptt.verifications.tree.Cell;
import org.eclipse.rcptt.verifications.tree.ItemData;
import org.eclipse.rcptt.verifications.tree.Row;
import org.eclipse.rcptt.verifications.tree.TreeVerificationUtils;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public class VerificationTreeLabelProvider
extends StyledCellLabelProvider {
    private Map<String, Image> images;
    boolean drawIcons;
    boolean ignoreStyle;
    boolean skipStyledText;

    public VerificationTreeLabelProvider(Map<String, Image> images, boolean drawIcons, boolean ignoreStyle, boolean skipStyledText) {
        this.images = images;
        this.drawIcons = drawIcons;
        this.ignoreStyle = ignoreStyle;
        this.skipStyledText = skipStyledText;
    }

    public void setDrawIcons(boolean drawIcons) {
        this.drawIcons = drawIcons;
    }

    public void setIgnoreStyle(boolean ignoreStyle) {
        this.ignoreStyle = ignoreStyle;
    }

    public void setSkipStyledText(boolean skipStyledText) {
        this.skipStyledText = skipStyledText;
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() instanceof Row) {
            Row row = (Row)cell.getElement();
            int ind = cell.getColumnIndex();
            if (row.getValues().size() > ind) {
                Cell cellValue = (Cell)row.getValues().get(ind);
                ItemData cellData = cellValue.getData();
                if (this.ignoreStyle) {
                    cell.setStyleRanges(null);
                    cell.setText(cellData.getText());
                } else {
                    StyleRange[] ranges = RangeUtils.fromEMF((List)cellValue.getStyle(), (Device)cell.getItem().getDisplay());
                    if (this.skipStyledText) {
                        cell.setStyleRanges(null);
                        cell.setText(StyleRangeUtils.getNonStyledText((StyleRange[])ranges, (String)cellData.getText()));
                    } else {
                        cell.setStyleRanges(ranges);
                        cell.setText(cellData.getText());
                    }
                }
                cell.setBackground(RangeUtils.colorFromEMF((Color)cellData.getBackgroundColor(), (Device)cell.getItem().getDisplay()));
                cell.setForeground(RangeUtils.colorFromEMF((Color)cellData.getForegroundColor(), (Device)cell.getItem().getDisplay()));
                if (this.drawIcons) {
                    String imgPath = TreeVerificationUtils.getDecoratedImagePath((org.eclipse.rcptt.tesla.core.ui.Image)cellData.getImage());
                    if (this.images.containsKey(imgPath)) {
                        cell.setImage(this.images.get(imgPath));
                    }
                } else {
                    cell.setImage(null);
                }
            }
        }
    }
}

