/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandTransferKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawEvent;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.recording.core.BaseTeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.IRecordingModeListener;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.ITeslaRecordingListener;
import org.eclipse.rcptt.tesla.recording.core.internal.Activator;

public class TeslaRecorder
extends BaseTeslaRecorder {
    private static TeslaRecorder instance;
    private List<ITeslaRecordingListener> listeners = new ArrayList<ITeslaRecordingListener>();
    private List<IRecordingModeListener> modeListeners = new ArrayList<IRecordingModeListener>();
    private List<IRecordingProcessor> processors = new ArrayList<IRecordingProcessor>();

    private void inializeProcessors() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rcptt.tesla.recording.core.recorder");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                IRecordingProcessor processor = (IRecordingProcessor)config.createExecutableExtension("class");
                this.processors.add(processor);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.rcptt.tesla.recording.core", e.getMessage(), (Throwable)e));
            }
            ++n2;
        }
        Collections.sort(this.processors, new Comparator<IRecordingProcessor>(){

            @Override
            public int compare(IRecordingProcessor o1, IRecordingProcessor o2) {
                return Integer.valueOf(o1.getInitLevel()).compareTo(o2.getInitLevel());
            }
        });
        for (IRecordingProcessor pr : this.processors) {
            try {
                pr.initialize(this);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.rcptt.tesla.recording.core", e.getMessage(), (Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void hookExecuteCommand(Command command, List<Element> elements, CommandTransferKind kind, List<Widget> controls, int index, List<RawEvent> rawEvents) {
        List<ITeslaRecordingListener> list = this.listeners;
        synchronized (list) {
            for (ITeslaRecordingListener listener : this.listeners) {
                listener.recordCommand(command, elements, kind, controls, index, rawEvents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ITeslaRecordingListener listener) {
        List<ITeslaRecordingListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ITeslaRecordingListener listener) {
        List<ITeslaRecordingListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IRecordingModeListener listener) {
        List<ITeslaRecordingListener> list = this.listeners;
        synchronized (list) {
            if (!this.modeListeners.contains(listener)) {
                this.modeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IRecordingModeListener listener) {
        List<ITeslaRecordingListener> list = this.listeners;
        synchronized (list) {
            this.modeListeners.remove(listener);
        }
    }

    public static synchronized TeslaRecorder getInstance() {
        if (instance == null) {
            instance = new TeslaRecorder();
            instance.inializeProcessors();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        List<ITeslaRecordingListener> list = this.listeners;
        synchronized (list) {
            return !this.listeners.isEmpty();
        }
    }

    public <T> T getProcessor(Class<T> clazz$) {
        for (IRecordingProcessor processor : this.processors) {
            if (!clazz$.getName().equals(processor.getClass().getName())) continue;
            return clazz$.cast(processor);
        }
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        for (IRecordingProcessor processor : this.processors) {
            processor.clear();
        }
    }

    public void setFreeze(boolean value, SetMode command) {
        for (IRecordingProcessor processor : this.processors) {
            processor.setFreeze(value, command);
        }
    }

    public <T> List<T> getProcessors(Class<T> clazz$) {
        ArrayList<T> result = new ArrayList<T>();
        for (IRecordingProcessor processor : this.processors) {
            if (!clazz$.isInstance(processor)) continue;
            result.add(clazz$.cast(processor));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySetRecordingMode(boolean b) {
        List<ITeslaRecordingListener> list = this.listeners;
        synchronized (list) {
            for (IRecordingModeListener listener : this.modeListeners) {
                listener.changeMode(b);
            }
        }
    }

    public void resetAssertSelection() {
        for (IRecordingProcessor processor : this.processors) {
            processor.resetAssertSelection();
        }
    }
}

