/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.CleanupUncomittedChangesDialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

public final class UIRepositoryUtils {
    private UIRepositoryUtils() {
    }

    public static boolean handleUncommittedFiles(Repository repo, Shell shell) throws GitAPIException {
        Status status = new Git(repo).status().call();
        if (status.hasUncommittedChanges()) {
            ArrayList<String> files = new ArrayList<String>(status.getModified());
            Collections.sort(files);
            String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(repo);
            CleanupUncomittedChangesDialog cleanupUncomittedChangesDialog = new CleanupUncomittedChangesDialog(shell, MessageFormat.format(UIText.AbstractRebaseCommandHandler_cleanupDialog_title, repoName), UIText.AbstractRebaseCommandHandler_cleanupDialog_text, repo, files);
            cleanupUncomittedChangesDialog.open();
            return cleanupUncomittedChangesDialog.shouldContinue();
        }
        return true;
    }
}

