/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.SerializationException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSCommand;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSItem;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSRun;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSRunContainerObject;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.CSAbstractSubDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details.SimpleCSCommandComboPart;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details.SimpleDetailsMessages;
import org.eclipse.pde.internal.ui.commands.CommandComposerDialog;
import org.eclipse.pde.internal.ui.commands.CommandComposerPart;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;

public class SimpleCSCommandDetails
extends CSAbstractSubDetails {
    private ISimpleCSRun fRun = null;
    private Table fCommandTable = null;
    private SimpleCSCommandComboPart fCommandCombo = null;
    private ControlDecoration fCommandInfoDecoration = null;
    private Button fCommandBrowse = null;
    private Button fCommandOptional = null;
    private static final String F_NO_COMMAND = SimpleDetailsMessages.SimpleCSCommandDetails_none;
    private static final int F_COMMAND_INSERTION_INDEX = 1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SimpleCSCommandDetails(ICSMaster section) {
        super(section, "simplecs-context");
    }

    public void setData(ISimpleCSRun object) {
        this.fRun = object;
    }

    public void createDetails(Composite parent) {
        int columnSpan = 3;
        Section commandSection = null;
        FormToolkit toolkit = this.getToolkit();
        Color foreground = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        GridData data = null;
        Label label = null;
        commandSection = toolkit.createSection(parent, 384);
        commandSection.clientVerticalSpacing = 6;
        commandSection.setText(SimpleDetailsMessages.SimpleCSCommandDetails_commandSectionText);
        commandSection.setDescription(SimpleDetailsMessages.SimpleCSCommandDetails_commandSectionDesc);
        commandSection.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        data = new GridData(768);
        commandSection.setLayoutData((Object)data);
        Composite commandSectionClient = toolkit.createComposite((Composite)commandSection);
        commandSectionClient.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)columnSpan));
        label = toolkit.createLabel(commandSectionClient, SimpleDetailsMessages.SimpleCSCommandDetails_attrCommand, 64);
        label.setForeground(foreground);
        this.fCommandCombo = new SimpleCSCommandComboPart();
        this.fCommandCombo.createControl(commandSectionClient, toolkit, 8);
        data = new GridData(768);
        data.horizontalIndent = 3;
        this.fCommandCombo.getControl().setLayoutData((Object)data);
        this.fCommandCombo.add(F_NO_COMMAND);
        this.fCommandCombo.setText(F_NO_COMMAND);
        this.fCommandCombo.populate();
        this.fCommandCombo.setNewCommandKeyIndex(1);
        this.fCommandCombo.setComboEntryLimit(11);
        this.createCommandInfoDecoration();
        this.fCommandBrowse = toolkit.createButton(commandSectionClient, SimpleDetailsMessages.SimpleCSCommandDetails_browse, 8);
        label = toolkit.createLabel(commandSectionClient, SimpleDetailsMessages.SimpleCSCommandDetails_attrParameters, 64);
        label.setForeground(foreground);
        data = new GridData(768);
        data.horizontalSpan = columnSpan;
        label.setLayoutData((Object)data);
        this.fCommandTable = toolkit.createTable(commandSectionClient, 68356);
        data = new GridData(768);
        data.heightHint = 25;
        data.horizontalSpan = columnSpan;
        this.fCommandTable.setLayoutData((Object)data);
        this.fCommandTable.setLinesVisible(true);
        TableColumn tableColumn1 = new TableColumn(this.fCommandTable, 16384);
        tableColumn1.setText(SimpleDetailsMessages.SimpleCSCommandDetails_name);
        TableColumn tableColumn2 = new TableColumn(this.fCommandTable, 16384);
        tableColumn2.setText(SimpleDetailsMessages.SimpleCSCommandDetails_value);
        this.fCommandOptional = this.getToolkit().createButton(commandSectionClient, SimpleDetailsMessages.SimpleCSCommandDetails_attrOptional, 32);
        data = new GridData(768);
        data.horizontalSpan = columnSpan;
        this.fCommandOptional.setLayoutData((Object)data);
        this.fCommandOptional.setForeground(foreground);
        toolkit.paintBordersFor(commandSectionClient);
        commandSection.setClient((Control)commandSectionClient);
        this.markDetailsPart((Control)commandSection);
    }

    private void createCommandInfoDecoration() {
        int bits = 16512;
        this.fCommandInfoDecoration = new ControlDecoration(this.fCommandCombo.getControl(), bits);
        this.fCommandInfoDecoration.setMarginWidth(1);
        this.fCommandInfoDecoration.setDescriptionText(SimpleDetailsMessages.SimpleCSCommandDetails_disabled);
        this.updateCommandInfoDecoration(false);
        this.fCommandInfoDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
    }

    public void hookListeners() {
        this.fCommandCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SimpleCSCommandDetails.this.fRun == null) {
                    return;
                }
                String selection = SimpleCSCommandDetails.this.fCommandCombo.getSelection();
                if (!selection.equals(F_NO_COMMAND)) {
                    String serialization = SimpleCSCommandDetails.this.fCommandCombo.getValue(selection);
                    if (PDETextHelper.isDefined((String)serialization)) {
                        SimpleCSCommandDetails.this.createCommandInModel(serialization);
                        ParameterizedCommand result = SimpleCSCommandDetails.this.getParameterizedCommand(serialization);
                        if (result != null) {
                            SimpleCSCommandDetails.this.updateCommandTable(result.getParameterMap());
                        }
                    }
                } else {
                    SimpleCSCommandDetails.this.fRun.setExecutable(null);
                    SimpleCSCommandDetails.this.fCommandTable.clearAll();
                }
                SimpleCSCommandDetails.this.getMasterSection().updateButtons();
                SimpleCSCommandDetails.this.updateUICommandOptional();
            }
        });
        this.fCommandBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SimpleCSCommandDetails.this.fRun == null) {
                    return;
                }
                CommandComposerDialog dialog = new CommandComposerDialog(SimpleCSCommandDetails.this.fCommandBrowse.getShell(), CommandComposerPart.F_CHEATSHEET_FILTER, SimpleCSCommandDetails.this.getParameterizedCommand(SimpleCSCommandDetails.this.fRun), SimpleCSCommandDetails.getSnapshotContext());
                if (dialog.open() == 0) {
                    SimpleCSCommandDetails.this.updateCommandCombo(dialog.getCommand(), true);
                    SimpleCSCommandDetails.this.getMasterSection().updateButtons();
                    SimpleCSCommandDetails.this.updateUICommandOptional();
                }
            }
        });
        this.fCommandOptional.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SimpleCSCommandDetails.this.fRun == null) {
                    return;
                }
                ISimpleCSCommand commandObject = SimpleCSCommandDetails.this.getCommandObject(SimpleCSCommandDetails.this.fRun);
                if (commandObject == null) {
                    return;
                }
                boolean isRequired = !SimpleCSCommandDetails.this.fCommandOptional.getSelection();
                commandObject.setRequired(isRequired);
            }
        });
    }

    public void updateFields() {
        if (this.fRun == null) {
            return;
        }
        ParameterizedCommand command = this.getParameterizedCommand(this.fRun);
        if (command == null) {
            this.clearCommandUI();
        } else {
            this.updateCommandCombo(command, false);
        }
        this.updateUICommandOptional();
        this.updateCommandEnablement();
    }

    private void updateUICommandOptional() {
        ISimpleCSCommand commandObject = this.getCommandObject(this.fRun);
        if (commandObject == null) {
            this.fCommandOptional.setSelection(false);
            this.fCommandOptional.setEnabled(false);
        } else {
            boolean isOptional = !commandObject.getRequired();
            this.fCommandOptional.setSelection(isOptional);
            this.fCommandOptional.setEnabled(this.isEditableElement());
        }
    }

    private ISimpleCSCommand getCommandObject(ISimpleCSRun runObject) {
        if (runObject == null) {
            return null;
        }
        ISimpleCSRunContainerObject executable = runObject.getExecutable();
        if (executable == null) {
            return null;
        }
        if (executable.getType() != 2) {
            return null;
        }
        return (ISimpleCSCommand)executable;
    }

    private void clearCommandUI() {
        this.fCommandCombo.setText(F_NO_COMMAND);
        this.fCommandTable.clearAll();
    }

    private void updateCommandEnablement() {
        if (this.fRun == null) {
            return;
        }
        boolean editable = this.isEditableElement();
        if (this.fRun.getType() == 6) {
            ISimpleCSItem item = (ISimpleCSItem)this.fRun;
            if (item.hasSubItems()) {
                editable = false;
                this.updateCommandInfoDecoration(true);
            } else {
                this.updateCommandInfoDecoration(false);
            }
        }
        this.fCommandCombo.setEnabled(editable);
        this.fCommandTable.setEnabled(true);
        this.fCommandBrowse.setEnabled(editable);
    }

    private void createCommandInModel(String serialization) {
        if (this.fRun == null) {
            return;
        }
        ISimpleCSCommand command = this.fRun.getModel().getFactory().createSimpleCSCommand((ISimpleCSObject)this.fRun);
        command.setSerialization(serialization);
        command.setRequired(false);
        this.fRun.setExecutable((ISimpleCSRunContainerObject)command);
    }

    private void updateCommandCombo(ParameterizedCommand result, boolean createInModel) {
        if (result == null) {
            return;
        }
        String serialization = result.serialize();
        String commandName = null;
        try {
            commandName = result.getCommand().getName();
        }
        catch (NotDefinedException notDefinedException) {}
        String commandId = result.getId();
        if (PDETextHelper.isDefined((String)serialization) && PDETextHelper.isDefined((String)commandId)) {
            if (createInModel) {
                this.createCommandInModel(serialization);
            }
            String nameToUse = null;
            nameToUse = PDETextHelper.isDefined((String)commandName) ? commandName : commandId;
            this.fCommandCombo.putValue(nameToUse, serialization, 1);
            this.fCommandCombo.setText(nameToUse);
            this.updateCommandTable(result.getParameterMap());
        } else {
            this.fCommandCombo.setText(F_NO_COMMAND);
        }
    }

    private ParameterizedCommand getParameterizedCommand(String serialization) {
        ICommandService service;
        if (PDETextHelper.isDefined((String)serialization) && (service = SimpleCSCommandDetails.getCommandService()) != null) {
            try {
                return service.deserialize(serialization);
            }
            catch (NotDefinedException e) {
                PDEUserAssistanceUIPlugin.logException(e, SimpleDetailsMessages.SimpleCSCommandDetails_errTitle, String.valueOf(SimpleDetailsMessages.SimpleCSCommandDetails_errMsg) + serialization);
            }
            catch (SerializationException e) {
                PDEUserAssistanceUIPlugin.logException(e, SimpleDetailsMessages.SimpleCSCommandDetails_errTitle, String.valueOf(SimpleDetailsMessages.SimpleCSCommandDetails_errMsg) + serialization);
            }
        }
        return null;
    }

    private ParameterizedCommand getParameterizedCommand(ISimpleCSRun run) {
        if (run == null) {
            return null;
        }
        ISimpleCSRunContainerObject object = run.getExecutable();
        if (object != null && object.getType() == 2) {
            ISimpleCSCommand command = (ISimpleCSCommand)object;
            return this.getParameterizedCommand(command.getSerialization());
        }
        return null;
    }

    private void updateCommandTable(Map parameters) {
        this.fCommandTable.clearAll();
        if (parameters != null && !parameters.isEmpty()) {
            Iterator it = parameters.keySet().iterator();
            int rowCount = 0;
            while (it.hasNext()) {
                Object value;
                TableItem item = null;
                item = rowCount < this.fCommandTable.getItemCount() ? this.fCommandTable.getItem(rowCount) : new TableItem(this.fCommandTable, 0);
                Object key = it.next();
                if (key instanceof String) {
                    String keyString = (String)key;
                    int dotIndex = keyString.lastIndexOf(46);
                    if (dotIndex != -1 && dotIndex != keyString.length() - 1) {
                        keyString = keyString.substring(dotIndex + 1);
                    }
                    item.setText(0, keyString);
                }
                if ((value = parameters.get(key)) instanceof String) {
                    item.setText(1, (String)value);
                }
                ++rowCount;
            }
            int i = 0;
            while (i < this.fCommandTable.getColumnCount()) {
                TableColumn tableColumn = this.fCommandTable.getColumn(i);
                tableColumn.pack();
                ++i;
            }
        }
    }

    private static ICommandService getCommandService() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ICommandService)workbench.getAdapter((Class)clazz);
    }

    private static IHandlerService getGlobalHandlerService() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IHandlerService)iWorkbench.getService((Class)clazz);
    }

    private static IEvaluationContext getSnapshotContext() {
        IHandlerService service = SimpleCSCommandDetails.getGlobalHandlerService();
        return service.createContextSnapshot(false);
    }

    private void updateCommandInfoDecoration(boolean showDecoration) {
        if (showDecoration) {
            this.fCommandInfoDecoration.show();
        } else {
            this.fCommandInfoDecoration.hide();
        }
        this.fCommandInfoDecoration.setShowHover(showDecoration);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }
}

