/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureData;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeatureURL;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.feature.FeatureDependenciesPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureFormPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureIncludesPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureReferencePage;
import org.eclipse.pde.internal.ui.editor.feature.InfoFormPage;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.editor.IFormPage;

public class FeatureOutlinePage
extends FormOutlinePage {
    private NamedElement fDiscoveryUrls;

    public FeatureOutlinePage(PDEFormEditor editor) {
        super(editor);
        Image folderImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_DOC_SECTION_OBJ);
        this.fDiscoveryUrls = new NamedElement(PDEUIMessages.FeatureOutlinePage_discoverUrls, folderImage);
    }

    @Override
    public ITreeContentProvider createContentProvider() {
        return new ContentProvider();
    }

    @Override
    public String getParentPageId(Object item) {
        if (item instanceof IFeaturePlugin) {
            return "reference";
        }
        if (item instanceof IFeatureChild) {
            return "includes";
        }
        if (item instanceof IFeatureImport) {
            return "dependencies";
        }
        if (item instanceof IFeatureInfo || item.equals(this.fDiscoveryUrls) || item instanceof IFeatureURLElement) {
            return "info";
        }
        if (item instanceof IBuildEntry) {
            return "build";
        }
        return super.getParentPageId(item);
    }

    private Object[] getInfos() {
        IFeatureModel model = (IFeatureModel)this.fEditor.getAggregateModel();
        IFeature feature = model.getFeature();
        Vector<Object> result = new Vector<Object>();
        int i = 0;
        while (i < 3) {
            IFeatureInfo info = feature.getFeatureInfo(i);
            if (info != null) {
                result.add(info);
            }
            ++i;
        }
        result.add(this.fDiscoveryUrls);
        return result.toArray();
    }

    private Object[] getReferences() {
        IFeatureModel model = (IFeatureModel)this.fEditor.getAggregateModel();
        IFeature feature = model.getFeature();
        return feature.getPlugins();
    }

    private Object[] getImports() {
        IFeatureModel model = (IFeatureModel)this.fEditor.getAggregateModel();
        IFeature feature = model.getFeature();
        return feature.getImports();
    }

    private Object[] getIncludes() {
        IFeatureModel model = (IFeatureModel)this.fEditor.getAggregateModel();
        IFeature feature = model.getFeature();
        return feature.getIncludedFeatures();
    }

    private Object[] getURLs() {
        IFeatureModel model = (IFeatureModel)this.fEditor.getAggregateModel();
        IFeature feature = model.getFeature();
        IFeatureURL url = feature.getURL();
        if (url == null) {
            return new Object[0];
        }
        return url.getDiscoveries();
    }

    public Object getParent(Object object) {
        if (object instanceof IFeatureURLElement) {
            return this.fDiscoveryUrls;
        }
        return this.fEditor.findPage(this.getParentPageId(object));
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        String property;
        if (this.fTreeViewer.getControl().isDisposed()) {
            return;
        }
        if (event.getChangeType() == 99) {
            this.fTreeViewer.refresh();
            return;
        }
        Object object = event.getChangedObjects()[0];
        if (object instanceof IFeature && event.getChangeType() == 3 && ((property = event.getChangedProperty()).equals("description") || property.equals("copyright") || property.equals("license"))) {
            IFormPage page = this.fEditor.findPage("info");
            this.fTreeViewer.refresh((Object)page);
            return;
        }
        if (object instanceof IFeatureImport || object instanceof IFeatureInfo || object instanceof IFeaturePlugin || object instanceof IFeatureData || object instanceof IFeatureURLElement || object instanceof IFeatureChild) {
            if (event.getChangeType() == 3) {
                this.fTreeViewer.update(object, null);
            } else {
                Object parent = this.getParent(object);
                if (parent != null) {
                    if (event.getChangeType() == 1) {
                        this.fTreeViewer.add(parent, event.getChangedObjects());
                    } else {
                        this.fTreeViewer.remove(event.getChangedObjects());
                    }
                } else {
                    this.fTreeViewer.refresh();
                    this.fTreeViewer.expandAll();
                }
            }
        }
    }

    class ContentProvider
    extends FormOutlinePage.BasicContentProvider {
        ContentProvider() {
        }

        @Override
        public Object[] getChildren(Object parent) {
            IFeatureModel model = (IFeatureModel)FeatureOutlinePage.this.fEditor.getAggregateModel();
            if (model != null && model.isValid()) {
                if (parent instanceof FeatureFormPage) {
                    return new Object[0];
                }
                if (parent instanceof InfoFormPage) {
                    return FeatureOutlinePage.this.getInfos();
                }
                if (parent.equals(FeatureOutlinePage.this.fDiscoveryUrls)) {
                    return FeatureOutlinePage.this.getURLs();
                }
                if (parent instanceof FeatureReferencePage) {
                    return FeatureOutlinePage.this.getReferences();
                }
                if (parent instanceof FeatureIncludesPage) {
                    return FeatureOutlinePage.this.getIncludes();
                }
                if (parent instanceof FeatureDependenciesPage) {
                    return FeatureOutlinePage.this.getImports();
                }
            }
            return super.getChildren(parent);
        }

        @Override
        public Object getParent(Object child) {
            String pageId = FeatureOutlinePage.this.getParentPageId(child);
            if (pageId != null) {
                return FeatureOutlinePage.this.fEditor.findPage(pageId);
            }
            return super.getParent(child);
        }
    }
}

