/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.operations.Activator;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.SynchronizeOperation;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationFactory {
    private IProvisioningAgent getAgent() {
        Collection ref = null;
        try {
            ref = Activator.getContext().getServiceReferences(IProvisioningAgent.class, "(agent.current=" + Boolean.TRUE.toString() + ')');
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (ref == null || ref.size() == 0) {
            throw new IllegalStateException(Messages.OperationFactory_noAgent);
        }
        IProvisioningAgent agent = (IProvisioningAgent)Activator.getContext().getService((ServiceReference)ref.iterator().next());
        Activator.getContext().ungetService((ServiceReference)ref.iterator().next());
        return agent;
    }

    private Collection<IInstallableUnit> gatherIUs(IQueryable<IInstallableUnit> searchContext, Collection<? extends IVersionedId> ius, boolean checkIUs, IProgressMonitor monitor) throws ProvisionException {
        ArrayList<IInstallableUnit> gatheredIUs = new ArrayList<IInstallableUnit>(ius.size());
        for (IVersionedId iVersionedId : ius) {
            if (!checkIUs && iVersionedId instanceof IInstallableUnit) {
                gatheredIUs.add((IInstallableUnit)iVersionedId);
                continue;
            }
            IQuery installableUnits = QueryUtil.createIUQuery((String)iVersionedId.getId(), (Version)iVersionedId.getVersion());
            IQueryResult matches = searchContext.query(installableUnits, monitor);
            if (matches.isEmpty()) {
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.operations", NLS.bind((String)Messages.OperationFactory_noIUFound, (Object)iVersionedId)));
            }
            Iterator iuIt = matches.iterator();
            gatheredIUs.add((IInstallableUnit)iuIt.next());
        }
        return gatheredIUs;
    }

    private ProvisioningContext createProvisioningContext(Collection<URI> repos, IProvisioningAgent agent) {
        ProvisioningContext ctx = new ProvisioningContext(agent);
        if (repos != null) {
            ctx.setMetadataRepositories(repos.toArray(new URI[repos.size()]));
            ctx.setArtifactRepositories(repos.toArray(new URI[repos.size()]));
        }
        return ctx;
    }

    public InstallOperation createInstallOperation(Collection<? extends IVersionedId> toInstall, Collection<URI> repos, IProgressMonitor monitor) throws ProvisionException {
        Assert.isNotNull(toInstall);
        IProvisioningAgent agent = this.getAgent();
        ProvisioningContext ctx = this.createProvisioningContext(repos, agent);
        InstallOperation resultingOperation = new InstallOperation(new ProvisioningSession(agent), this.gatherIUs((IQueryable<IInstallableUnit>)ctx.getMetadata(monitor), toInstall, false, monitor));
        resultingOperation.setProvisioningContext(ctx);
        resultingOperation.setProfileId("_SELF_");
        return resultingOperation;
    }

    public UninstallOperation createUninstallOperation(Collection<? extends IVersionedId> toUninstall, Collection<URI> repos, IProgressMonitor monitor) throws ProvisionException {
        Assert.isNotNull(toUninstall);
        IProvisioningAgent agent = this.getAgent();
        ProvisioningContext ctx = this.createProvisioningContext(repos, agent);
        UninstallOperation resultingOperation = new UninstallOperation(new ProvisioningSession(agent), this.gatherIUs((IQueryable<IInstallableUnit>)this.listInstalledElements(false, monitor), toUninstall, true, monitor));
        resultingOperation.setProvisioningContext(ctx);
        resultingOperation.setProfileId("_SELF_");
        return resultingOperation;
    }

    public IQueryResult<IInstallableUnit> listInstalledElements(boolean rootsOnly, IProgressMonitor monitor) {
        IProfileRegistry registry = (IProfileRegistry)this.getAgent().getService(IProfileRegistry.SERVICE_NAME);
        IProfile profile = registry.getProfile("_SELF_");
        if (rootsOnly) {
            return profile.query((IQuery)new UserVisibleRootQuery(), monitor);
        }
        return profile.query(QueryUtil.ALL_UNITS, monitor);
    }

    public UpdateOperation createUpdateOperation(Collection<? extends IVersionedId> toUpdate, Collection<URI> repos, IProgressMonitor monitor) throws ProvisionException {
        IProvisioningAgent agent = this.getAgent();
        ProvisioningContext ctx = this.createProvisioningContext(repos, agent);
        UpdateOperation resultingOperation = new UpdateOperation(new ProvisioningSession(agent), toUpdate == null ? null : this.gatherIUs((IQueryable<IInstallableUnit>)this.listInstalledElements(false, monitor), toUpdate, false, monitor));
        resultingOperation.setProvisioningContext(ctx);
        resultingOperation.setProfileId("_SELF_");
        return resultingOperation;
    }

    public SynchronizeOperation createSynchronizeOperation(Collection<? extends IVersionedId> toInstall, Collection<URI> repos, IProgressMonitor monitor) throws ProvisionException {
        IProvisioningAgent agent = this.getAgent();
        ProvisioningContext ctx = this.createProvisioningContext(repos, agent);
        Collection<Object> iusToInstall = toInstall == null ? ctx.getMetadata(monitor).query(QueryUtil.createIUGroupQuery(), monitor).toUnmodifiableSet() : this.gatherIUs((IQueryable<IInstallableUnit>)ctx.getMetadata(monitor), toInstall, false, monitor);
        SynchronizeOperation resultingOperation = new SynchronizeOperation(new ProvisioningSession(agent), iusToInstall);
        resultingOperation.setProvisioningContext(ctx);
        resultingOperation.setProfileId("_SELF_");
        return resultingOperation;
    }
}

