/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util;

import org.eclipse.rcptt.util.Predicate;

public class Predicates {
    public static <T> Predicate<T> not(final Predicate<T> predicate) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T input) {
                return !predicate.apply(input);
            }
        };
    }

    public static <T> Predicate<T> and(final Predicate<T> ... predicates) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T input) {
                Predicate[] predicateArray = predicates;
                int n = predicates.length;
                int n2 = 0;
                while (n2 < n) {
                    Predicate predicate = predicateArray[n2];
                    if (!predicate.apply(input)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<T> ... predicates) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T input) {
                Predicate[] predicateArray = predicates;
                int n = predicates.length;
                int n2 = 0;
                while (n2 < n) {
                    Predicate predicate = predicateArray[n2];
                    if (predicate.apply(input)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> ife(final Predicate<T> cond, final Predicate<T> t, final Predicate<T> f) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T input) {
                return cond.apply(input) ? t.apply(input) : f.apply(input);
            }
        };
    }
}

