/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core.info;

import java.util.Map;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.InfoFactory;
import org.eclipse.rcptt.tesla.core.info.JobEntry;
import org.eclipse.rcptt.tesla.core.info.StackTraceEntry;
import org.eclipse.rcptt.tesla.internal.core.info.InfoUtils;

public class GeneralInformationCollector {
    public static void collectInformation(AdvancedInformation information) {
        GeneralInformationCollector.collectJobInformation(information);
        GeneralInformationCollector.collectThreadInformation(information);
        Runtime runtime = Runtime.getRuntime();
        InfoUtils.Node nde = InfoUtils.newNode("java.runtime").add(information);
        nde.property("cpus", Integer.toString(runtime.availableProcessors()));
        nde.property("freeMemory", Long.toString(runtime.freeMemory()));
        nde.property("totalMemory", Long.toString(runtime.totalMemory()));
        nde.property("maxMemory", Long.toString(runtime.maxMemory()));
    }

    private static void collectThreadInformation(AdvancedInformation information) {
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> e : allStackTraces.entrySet()) {
            Thread key = e.getKey();
            StackTraceElement[] value = e.getValue();
            StackTraceEntry entry = InfoFactory.eINSTANCE.createStackTraceEntry();
            entry.setId(Integer.toHexString(key.hashCode()));
            entry.setThreadClass(key.getClass().getName());
            entry.setThreadName(key.getName());
            StackTraceElement[] stackTraceElementArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                entry.getStackTrace().add((Object)stackTraceElement.toString());
                ++n2;
            }
            information.getThreads().add((Object)entry);
        }
    }

    private static void collectJobInformation(AdvancedInformation information) {
        Job[] find;
        IJobManager manager = Job.getJobManager();
        Job[] jobArray = find = manager.find(null);
        int n = find.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            JobEntry entry = InfoFactory.eINSTANCE.createJobEntry();
            entry.setId(Integer.toHexString(job.hashCode()));
            entry.setJobClass(job.getClass().getName());
            entry.setName(job.getName());
            entry.setState(GeneralInformationCollector.stateToString(job));
            ISchedulingRule rule = job.getRule();
            if (rule != null) {
                entry.setRule(rule.toString());
                entry.setRuleClass(rule.getClass().getName());
            }
            information.getJobs().add((Object)entry);
            ++n2;
        }
    }

    private static String stateToString(Job job) {
        switch (job.getState()) {
            case 4: {
                return "running";
            }
            case 1: {
                return "sleeping";
            }
            case 0: {
                return "none";
            }
            case 2: {
                return "waiting";
            }
        }
        return "unknown";
    }
}

