/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jdt.internal.ui.actions.FoldingActionGroup;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.ToggleBreadcrumbAction;
import org.eclipse.jdt.internal.ui.javaeditor.ToggleMarkOccurrencesAction;
import org.eclipse.jdt.internal.ui.javaeditor.TogglePresentationAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class BasicJavaEditorActionContributor
extends BasicTextEditorActionContributor {
    private List<RetargetAction> fPartListeners = new ArrayList<RetargetAction>();
    private TogglePresentationAction fTogglePresentation;
    private ToggleMarkOccurrencesAction fToggleMarkOccurrencesAction;
    private ToggleBreadcrumbAction fToggleBreadcrumbAction;
    private RetargetTextEditorAction fGotoMatchingBracket;
    private RetargetTextEditorAction fShowOutline;
    private RetargetTextEditorAction fOpenStructure;
    private RetargetTextEditorAction fOpenHierarchy;
    private RetargetTextEditorAction fRetargetShowInformationAction;
    private RetargetTextEditorAction fStructureSelectEnclosingAction;
    private RetargetTextEditorAction fStructureSelectNextAction;
    private RetargetTextEditorAction fStructureSelectPreviousAction;
    private RetargetTextEditorAction fStructureSelectHistoryAction;
    private RetargetTextEditorAction fGotoNextMemberAction;
    private RetargetTextEditorAction fGotoPreviousMemberAction;
    private RetargetTextEditorAction fRemoveOccurrenceAnnotationsAction;

    public BasicJavaEditorActionContributor() {
        ResourceBundle b = JavaEditorMessages.getBundleForConstructedKeys();
        this.fRetargetShowInformationAction = new RetargetTextEditorAction(b, "Editor.ShowInformation.");
        this.fRetargetShowInformationAction.setActionDefinitionId("org.eclipse.ui.edit.text.showInformation");
        this.fTogglePresentation = new TogglePresentationAction();
        this.fToggleMarkOccurrencesAction = new ToggleMarkOccurrencesAction();
        this.fGotoMatchingBracket = new RetargetTextEditorAction(b, "GotoMatchingBracket.");
        this.fGotoMatchingBracket.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.matching.bracket");
        this.fShowOutline = new RetargetTextEditorAction(JavaEditorMessages.getBundleForConstructedKeys(), "ShowOutline.");
        this.fShowOutline.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.show.outline");
        this.fOpenHierarchy = new RetargetTextEditorAction(JavaEditorMessages.getBundleForConstructedKeys(), "OpenHierarchy.");
        this.fOpenHierarchy.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.hierarchy");
        this.fOpenStructure = new RetargetTextEditorAction(JavaEditorMessages.getBundleForConstructedKeys(), "OpenStructure.");
        this.fOpenStructure.setActionDefinitionId("org.eclipse.jdt.ui.navigate.java.open.structure");
        this.fStructureSelectEnclosingAction = new RetargetTextEditorAction(b, "StructureSelectEnclosing.");
        this.fStructureSelectEnclosingAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.enclosing");
        this.fStructureSelectNextAction = new RetargetTextEditorAction(b, "StructureSelectNext.");
        this.fStructureSelectNextAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.next");
        this.fStructureSelectPreviousAction = new RetargetTextEditorAction(b, "StructureSelectPrevious.");
        this.fStructureSelectPreviousAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.previous");
        this.fStructureSelectHistoryAction = new RetargetTextEditorAction(b, "StructureSelectHistory.");
        this.fStructureSelectHistoryAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.last");
        this.fGotoNextMemberAction = new RetargetTextEditorAction(b, "GotoNextMember.");
        this.fGotoNextMemberAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.next.member");
        this.fGotoPreviousMemberAction = new RetargetTextEditorAction(b, "GotoPreviousMember.");
        this.fGotoPreviousMemberAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.previous.member");
        this.fRemoveOccurrenceAnnotationsAction = new RetargetTextEditorAction(b, "RemoveOccurrenceAnnotations.");
        this.fRemoveOccurrenceAnnotationsAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.remove.occurrence.annotations");
    }

    protected final void markAsPartListener(RetargetAction action) {
        this.fPartListeners.add(action);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        this.fToggleBreadcrumbAction = new ToggleBreadcrumbAction(page);
        Iterator<RetargetAction> e = this.fPartListeners.iterator();
        while (e.hasNext()) {
            page.addPartListener((IPartListener)e.next());
        }
        super.init(bars, page);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
        bars.setGlobalActionHandler("org.eclipse.jdt.ui.edit.text.java.toggleMarkOccurrences", (IAction)this.fToggleMarkOccurrencesAction);
        bars.setGlobalActionHandler("org.eclipse.jdt.ui.edit.text.java.toggleBreadcrumb", (IAction)this.fToggleBreadcrumbAction);
    }

    public void contributeToMenu(IMenuManager menu) {
        IMenuManager gotoMenu;
        IMenuManager navigateMenu;
        super.contributeToMenu(menu);
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            MenuManager structureSelection = new MenuManager(JavaEditorMessages.ExpandSelectionMenu_label, "expandSelection");
            editMenu.insertAfter(ITextEditorActionConstants.SELECT_ALL, (IContributionItem)structureSelection);
            structureSelection.add((IAction)this.fStructureSelectEnclosingAction);
            structureSelection.add((IAction)this.fStructureSelectNextAction);
            structureSelection.add((IAction)this.fStructureSelectPreviousAction);
            structureSelection.add((IAction)this.fStructureSelectHistoryAction);
            editMenu.appendToGroup("group.information", (IAction)this.fRetargetShowInformationAction);
        }
        if ((navigateMenu = menu.findMenuUsingPath("navigate")) != null) {
            navigateMenu.appendToGroup("show.ext", (IAction)this.fShowOutline);
            navigateMenu.appendToGroup("show.ext", (IAction)this.fOpenHierarchy);
        }
        if ((gotoMenu = menu.findMenuUsingPath("navigate/goTo")) != null) {
            gotoMenu.add((IContributionItem)new Separator("additions2"));
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoPreviousMemberAction);
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoNextMemberAction);
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoMatchingBracket);
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        ITextEditor textEditor = null;
        if (part instanceof ITextEditor) {
            textEditor = (ITextEditor)part;
        }
        this.fTogglePresentation.setEditor(textEditor);
        this.fToggleMarkOccurrencesAction.setEditor(textEditor);
        this.fGotoMatchingBracket.setAction(this.getAction(textEditor, "GotoMatchingBracket"));
        this.fShowOutline.setAction(this.getAction(textEditor, "org.eclipse.jdt.ui.edit.text.java.show.outline"));
        this.fOpenHierarchy.setAction(this.getAction(textEditor, "org.eclipse.jdt.ui.edit.text.java.open.hierarchy"));
        this.fOpenStructure.setAction(this.getAction(textEditor, "org.eclipse.jdt.ui.navigate.java.open.structure"));
        this.fStructureSelectEnclosingAction.setAction(this.getAction(textEditor, "SelectEnclosingElement"));
        this.fStructureSelectNextAction.setAction(this.getAction(textEditor, "SelectNextElement"));
        this.fStructureSelectPreviousAction.setAction(this.getAction(textEditor, "SelectPreviousElement"));
        this.fStructureSelectHistoryAction.setAction(this.getAction(textEditor, "RestoreLastSelection"));
        this.fGotoNextMemberAction.setAction(this.getAction(textEditor, "GoToNextMember"));
        this.fGotoPreviousMemberAction.setAction(this.getAction(textEditor, "GoToPreviousMember"));
        this.fRemoveOccurrenceAnnotationsAction.setAction(this.getAction(textEditor, "RemoveOccurrenceAnnotations"));
        this.fRetargetShowInformationAction.setAction(this.getAction(textEditor, "ShowInformation"));
        if (part instanceof JavaEditor) {
            JavaEditor javaEditor = (JavaEditor)part;
            javaEditor.getActionGroup().fillActionBars(this.getActionBars());
            FoldingActionGroup foldingActions = javaEditor.getFoldingActionGroup();
            if (foldingActions != null) {
                foldingActions.updateActionBars();
            }
        }
        IActionBars actionBars = this.getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        manager.setMessage(null);
        manager.setErrorMessage(null);
        IAction action = this.getAction(textEditor, ITextEditorActionConstants.NEXT);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, action);
        action = this.getAction(textEditor, ITextEditorActionConstants.PREVIOUS);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, action);
        action = this.getAction(textEditor, "copyQualifiedName");
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.CopyQualifiedName", action);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.edit.text.java.gotoBreadcrumb", this.getAction(textEditor, "org.eclipse.jdt.ui.edit.text.java.gotoBreadcrumb"));
        actionBars.setGlobalActionHandler("org.eclipse.jdt.internal.ui.actions.OpenHyperlink", this.getAction(textEditor, "OpenHyperlink"));
    }

    public void dispose() {
        Iterator<RetargetAction> e = this.fPartListeners.iterator();
        while (e.hasNext()) {
            this.getPage().removePartListener((IPartListener)e.next());
        }
        this.fPartListeners.clear();
        this.setActiveEditor(null);
        this.fToggleBreadcrumbAction.dispose();
        super.dispose();
    }
}

