/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.trace.internal.datamodel;

import org.eclipse.ui.trace.internal.datamodel.AbstractTracingNode;
import org.eclipse.ui.trace.internal.datamodel.TracingNode;
import org.eclipse.ui.trace.internal.utils.DebugOptionsHandler;
import org.eclipse.ui.trace.internal.utils.TracingUtils;

public class TracingComponentDebugOption
extends AbstractTracingNode {
    private final String fOptionPath;
    private String fOptionPathValue;

    public TracingComponentDebugOption(String path, String value) {
        this(null, path, value);
    }

    public TracingComponentDebugOption(TracingNode parentNode, String path, String value) {
        assert (path != null);
        assert (value != null);
        this.fOptionPath = path;
        this.fOptionPathValue = value;
        this.setParent(parentNode);
        this.setLabel(path);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TracingComponentDebugOption [fOptionPath=");
        builder.append(this.fOptionPath);
        builder.append(", fOptionPathValue=");
        builder.append(this.fOptionPathValue);
        builder.append(", parent=");
        if (this.getParent() != null) {
            builder.append(this.getParent());
        } else {
            builder.append("<unset>");
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fOptionPath == null ? 0 : this.fOptionPath.hashCode());
        result = 31 * result + (this.getParent() == null ? 0 : this.getParent().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TracingComponentDebugOption)) {
            return false;
        }
        TracingComponentDebugOption other = (TracingComponentDebugOption)obj;
        if (this.fOptionPath == null ? other.fOptionPath != null : !this.fOptionPath.equals(other.fOptionPath)) {
            return false;
        }
        return !(this.getParent() == null ? other.getParent() != null : !this.getParent().equals(other.getParent()));
    }

    public boolean isEnabled() {
        String value;
        boolean isEnabled = false;
        isEnabled = TracingUtils.isValueBoolean(this.fOptionPathValue) ? Boolean.parseBoolean(this.fOptionPathValue) : (value = DebugOptionsHandler.getDebugOptions().getOption(this.fOptionPath)) != null;
        return isEnabled;
    }

    protected void populateChildren() {
    }

    public final TracingComponentDebugOption[] getChildren() {
        return new TracingComponentDebugOption[0];
    }

    public String getOptionPath() {
        return this.fOptionPath;
    }

    public String getOptionPathValue() {
        return this.fOptionPathValue;
    }

    public void setOptionPathValue(String newValue) {
        assert (newValue != null);
        this.fOptionPathValue = newValue;
    }

    public void setOptionPathValue(boolean newValue) {
        this.fOptionPathValue = Boolean.toString(newValue);
    }

    public TracingComponentDebugOption clone() {
        return new TracingComponentDebugOption(this.getParent(), this.fOptionPath, this.fOptionPathValue);
    }
}

