/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.internal.decorators.IDecoratableResource;
import org.eclipse.egit.ui.internal.decorators.IProblemDecoratable;
import org.eclipse.egit.ui.internal.staging.StagingFolderEntry;
import org.eclipse.jgit.lib.Repository;

public class StagingEntry
implements IAdaptable,
IProblemDecoratable,
IDecoratableResource {
    private final Repository repository;
    private final State state;
    private final String path;
    private final IFile file;
    private String name;
    private StagingFolderEntry parent;
    private boolean submodule;
    private boolean symlink;

    public StagingEntry(Repository repository, State state, String path) {
        this.repository = repository;
        this.state = state;
        this.path = path;
        this.file = ResourceUtil.getFileForLocation((Repository)repository, (String)path);
    }

    public void setSubmodule(boolean submodule) {
        this.submodule = submodule;
    }

    public boolean isSubmodule() {
        return this.submodule;
    }

    public void setSymlink(boolean symlink) {
        this.symlink = symlink;
    }

    public boolean isSymlink() {
        return this.symlink;
    }

    public String getPath() {
        return this.path;
    }

    public IPath getParentPath() {
        return new Path(this.path).removeLastSegments(1);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public State getState() {
        return this.state;
    }

    Set<Action> getAvailableActions() {
        return this.state.getAvailableActions();
    }

    public IFile getFile() {
        return this.file;
    }

    public IPath getLocation() {
        IPath absolutePath = new Path(this.repository.getWorkTree().getAbsolutePath()).append(this.path);
        return absolutePath;
    }

    public StagingFolderEntry getParent() {
        return this.parent;
    }

    public void setParent(StagingFolderEntry parent) {
        this.parent = parent;
    }

    @Override
    public int getProblemSeverity() {
        if (this.file == null) {
            return -1;
        }
        try {
            return this.file.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 1);
        }
        catch (CoreException coreException) {
            return -1;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            return this.getFile();
        }
        if (adapter == IPath.class) {
            return this.getLocation();
        }
        return null;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            IPath parsed = Path.fromOSString((String)this.getPath());
            this.name = parsed.lastSegment();
        }
        return this.name;
    }

    @Override
    public String getRepositoryName() {
        return null;
    }

    @Override
    public String getBranch() {
        return null;
    }

    @Override
    public String getBranchStatus() {
        return null;
    }

    @Override
    public boolean isTracked() {
        return this.state != State.UNTRACKED;
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    public boolean isDirty() {
        return this.state == State.MODIFIED || this.state == State.MODIFIED_AND_CHANGED || this.state == State.MODIFIED_AND_ADDED;
    }

    @Override
    public IDecoratableResource.Staged staged() {
        switch (this.state) {
            case ADDED: {
                return IDecoratableResource.Staged.ADDED;
            }
            case CHANGED: {
                return IDecoratableResource.Staged.MODIFIED;
            }
            case REMOVED: {
                return IDecoratableResource.Staged.REMOVED;
            }
            case MISSING: 
            case MISSING_AND_CHANGED: {
                return IDecoratableResource.Staged.REMOVED;
            }
        }
        return IDecoratableResource.Staged.NOT_STAGED;
    }

    @Override
    public boolean hasConflicts() {
        return this.state == State.CONFLICTING;
    }

    @Override
    public boolean isAssumeValid() {
        return false;
    }

    public String toString() {
        return "StagingEntry[" + (Object)((Object)this.state) + " " + this.path + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StagingEntry other = (StagingEntry)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return this.state == other.state;
    }

    static enum Action {
        REPLACE_WITH_FILE_IN_GIT_INDEX,
        REPLACE_WITH_HEAD_REVISION,
        STAGE,
        UNSTAGE,
        DELETE,
        IGNORE,
        LAUNCH_MERGE_TOOL,
        REPLACE_WITH_OURS_THEIRS_MENU;

    }

    public static enum State {
        ADDED(EnumSet.of(Action.UNSTAGE)),
        CHANGED(EnumSet.of(Action.REPLACE_WITH_HEAD_REVISION, Action.UNSTAGE)),
        REMOVED(EnumSet.of(Action.REPLACE_WITH_HEAD_REVISION, Action.UNSTAGE)),
        MISSING(EnumSet.of(Action.REPLACE_WITH_HEAD_REVISION, Action.STAGE)),
        MISSING_AND_CHANGED(EnumSet.of(Action.REPLACE_WITH_FILE_IN_GIT_INDEX, Action.REPLACE_WITH_HEAD_REVISION, Action.STAGE)),
        MODIFIED(EnumSet.of(Action.REPLACE_WITH_HEAD_REVISION, Action.STAGE)),
        MODIFIED_AND_CHANGED(EnumSet.of(Action.REPLACE_WITH_FILE_IN_GIT_INDEX, Action.REPLACE_WITH_HEAD_REVISION, Action.STAGE)),
        MODIFIED_AND_ADDED(EnumSet.of(Action.REPLACE_WITH_FILE_IN_GIT_INDEX, Action.STAGE)),
        UNTRACKED(EnumSet.of(Action.STAGE, Action.DELETE, Action.IGNORE)),
        CONFLICTING(EnumSet.of(Action.REPLACE_WITH_FILE_IN_GIT_INDEX, Action.REPLACE_WITH_HEAD_REVISION, Action.STAGE, Action.LAUNCH_MERGE_TOOL, Action.REPLACE_WITH_OURS_THEIRS_MENU));

        private final Set<Action> availableActions;

        private State(Set<Action> availableActions) {
            this.availableActions = availableActions;
        }

        public Set<Action> getAvailableActions() {
            return this.availableActions;
        }
    }
}

