/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.internal.core.refactoring.Lock;
import org.eclipse.ltk.internal.core.refactoring.TextChanges;
import org.eclipse.ltk.internal.core.refactoring.UndoDocumentChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.UndoEdit;

public class DocumentChange
extends TextChange {
    private IDocument fDocument;
    private int fLength;

    public DocumentChange(String name, IDocument document) {
        super(name);
        Assert.isNotNull((Object)document);
        this.fDocument = document;
    }

    public Object getModifiedElement() {
        return this.fDocument;
    }

    public void initializeValidationData(IProgressMonitor pm) {
        this.fLength = this.fDocument.getLength();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        RefactoringStatus result = TextChanges.isValid(this.fDocument, this.fLength);
        pm.worked(1);
        return result;
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        return this.fDocument;
    }

    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UndoEdit performEdits(final IDocument document) throws BadLocationException, MalformedTreeException {
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer fileBuffer = fileBufferManager.getTextFileBuffer(document);
        if (fileBuffer == null || !fileBuffer.isSynchronizationContextRequested()) {
            return super.performEdits(document);
        }
        final Lock completionLock = new Lock();
        final UndoEdit[] result = new UndoEdit[1];
        final BadLocationException[] exception = new BadLocationException[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Lock lock = completionLock;
                synchronized (lock) {
                    block8: {
                        try {
                            try {
                                result[0] = DocumentChange.super.performEdits(document);
                            }
                            catch (BadLocationException e) {
                                exception[0] = e;
                                completionLock.fDone = true;
                                completionLock.notifyAll();
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            completionLock.fDone = true;
                            completionLock.notifyAll();
                            throw throwable;
                        }
                        completionLock.fDone = true;
                        completionLock.notifyAll();
                    }
                }
            }
        };
        Lock lock = completionLock;
        synchronized (lock) {
            fileBufferManager.execute(runnable);
            while (!completionLock.fDone) {
                try {
                    completionLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        return result[0];
    }

    protected Change createUndoChange(UndoEdit edit) {
        return new UndoDocumentChange(this.getName(), this.fDocument, edit);
    }
}

