/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.ExternalFeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.TargetDefinition;

public class FeatureBundleContainer
extends AbstractBundleContainer {
    public static final String TYPE = "Feature";
    private String fId;
    private String fVersion;
    private String fHome;

    FeatureBundleContainer(String home, String name, String version) {
        this.fId = name;
        this.fVersion = version;
        this.fHome = home;
    }

    @Override
    public String getLocation(boolean resolve) throws CoreException {
        if (resolve) {
            return this.resolveHomeLocation().toOSString();
        }
        return this.fHome;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getFeatureId() {
        return this.fId;
    }

    public String getFeatureVersion() {
        return this.fVersion;
    }

    private IPath resolveHomeLocation() throws CoreException {
        return new Path(this.resolveVariables(this.fHome));
    }

    @Override
    protected TargetBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        IBaseModel model = null;
        try {
            if (monitor.isCanceled()) {
                TargetBundle[] targetBundleArray = new TargetBundle[]{};
                return targetBundleArray;
            }
            TargetFeature[] features = this.resolveFeatures(definition, null);
            if (features.length == 0) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.FeatureBundleContainer_1, (Object)this.fId)));
            }
            File location = new File(features[0].getLocation());
            if (!location.exists()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.FeatureBundleContainer_0, (Object)location.toString())));
            }
            File manifest = new File(location, "feature.xml");
            if (!manifest.exists() || !manifest.isFile()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.FeatureBundleContainer_2, (Object)this.fId)));
            }
            model = ExternalFeatureModelManager.createModel(manifest);
            if (model == null || !model.isLoaded()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.FeatureBundleContainer_2, (Object)this.fId)));
            }
            ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class.getName());
            if (service == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.FeatureBundleContainer_4));
            }
            if (monitor.isCanceled()) {
                TargetBundle[] targetBundleArray = new TargetBundle[]{};
                return targetBundleArray;
            }
            ITargetLocation container = service.newProfileLocation(this.getLocation(false), null);
            container.resolve(definition, monitor);
            TargetBundle[] bundles = container.getBundles();
            IFeature feature = model.getFeature();
            IFeaturePlugin[] plugins = feature.getPlugins();
            ArrayList<NameVersionDescriptor> matchInfos = new ArrayList<NameVersionDescriptor>(plugins.length);
            int i = 0;
            while (i < plugins.length) {
                if (monitor.isCanceled()) {
                    TargetBundle[] targetBundleArray = new TargetBundle[]{};
                    return targetBundleArray;
                }
                IFeaturePlugin plugin = plugins[i];
                if (this.isMatch(definition.getArch(), plugin.getArch(), Platform.getOSArch()) && this.isMatch(definition.getNL(), plugin.getNL(), Platform.getNL()) && this.isMatch(definition.getOS(), plugin.getOS(), Platform.getOS()) && this.isMatch(definition.getWS(), plugin.getWS(), Platform.getWS())) {
                    matchInfos.add(new NameVersionDescriptor(plugin.getId(), plugin.getVersion()));
                }
                ++i;
            }
            List<TargetBundle> result = TargetDefinition.getMatchingBundles(bundles, matchInfos.toArray(new NameVersionDescriptor[matchInfos.size()]), true);
            TargetBundle[] targetBundleArray = result.toArray(new TargetBundle[result.size()]);
            return targetBundleArray;
        }
        finally {
            if (model != null) {
                model.dispose();
            }
        }
    }

    @Override
    protected TargetFeature[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        if (definition instanceof TargetDefinition) {
            TargetFeature[] allFeatures = ((TargetDefinition)definition).resolveFeatures(this.getLocation(false), monitor);
            int i = 0;
            while (i < allFeatures.length) {
                if (allFeatures[i].getId().equals(this.fId) && (this.fVersion == null || allFeatures[i].getVersion().equals(this.fVersion))) {
                    return new TargetFeature[]{allFeatures[i]};
                }
                ++i;
            }
        }
        return new TargetFeature[0];
    }

    private boolean isMatch(String targetValue, String fragmentValue, String runningValue) {
        if (fragmentValue == null) {
            return true;
        }
        if (targetValue == null) {
            return runningValue.equals(fragmentValue);
        }
        return targetValue.equals(fragmentValue);
    }

    public boolean equals(Object o) {
        if (o instanceof FeatureBundleContainer) {
            FeatureBundleContainer fbc = (FeatureBundleContainer)o;
            return this.fHome.equals(fbc.fHome) && this.fId.equals(fbc.fId) && this.isNullOrEqual(this.fVersion, this.fVersion);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.fHome.hashCode() + this.fId.hashCode();
        if (this.fVersion != null) {
            hash += this.fVersion.hashCode();
        }
        return hash;
    }

    private boolean isNullOrEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public String toString() {
        return new StringBuffer().append("Feature ").append(this.fId).append(' ').append(this.fVersion).append(' ').append(this.fHome).toString();
    }

    @Override
    public String[] getVMArguments() {
        return null;
    }
}

