/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Vector;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaEnumeration;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.schema.ChoiceRestriction;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaEnumeration;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.eclipse.pde.internal.core.util.PDESchemaHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.editor.schema.FilteredSchemaAttributeSelectionDialog;
import org.eclipse.pde.internal.ui.editor.schema.NewRestrictionDialog;
import org.eclipse.pde.internal.ui.editor.schema.SchemaAttributeDetails;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SchemaIdentifierAttributeDetails
extends SchemaAttributeDetails {
    private FormEntry fReferenceEntry;
    private TableViewer fRestrictionsTable;
    private Button fAddRestriction;
    private Button fRemoveRestriction;

    public SchemaIdentifierAttributeDetails(ElementSection section) {
        super(section);
    }

    @Override
    protected void createTypeDetails(Composite parent, FormToolkit toolkit) {
        GridData gd = new GridData(768);
        gd.heightHint = 40;
        gd.horizontalIndent = 3;
        this.fReferenceEntry = new FormEntry(parent, toolkit, PDEUIMessages.SchemaStringAttributeDetails_reference, PDEUIMessages.SchemaAttributeDetails_browseButton, false, 11);
        Color foreground = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        Label label = toolkit.createLabel(parent, PDEUIMessages.SchemaIdentifierAttributeDetails_additionalRestrictions);
        label.setForeground(foreground);
        gd = new GridData(2);
        gd.horizontalIndent = 11;
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        Composite tableComp = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableComp.setLayout((Layout)layout);
        tableComp.setLayoutData((Object)new GridData(768));
        Table table = toolkit.createTable(tableComp, 2562);
        gd = new GridData(768);
        gd.heightHint = 40;
        gd.horizontalIndent = 3;
        table.setLayoutData((Object)gd);
        this.fRestrictionsTable = new TableViewer(table);
        this.fRestrictionsTable.setContentProvider((IContentProvider)new SchemaAttributeDetails.SchemaAttributeContentProvider());
        this.fRestrictionsTable.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        Composite resButtonComp = toolkit.createComposite(parent);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        resButtonComp.setLayout((Layout)layout);
        resButtonComp.setLayoutData((Object)new GridData(2));
        this.fAddRestriction = toolkit.createButton(resButtonComp, PDEUIMessages.SchemaAttributeDetails_addRestButton, 0);
        this.fRemoveRestriction = toolkit.createButton(resButtonComp, PDEUIMessages.SchemaAttributeDetails_removeRestButton, 0);
        this.fAddRestriction.setLayoutData((Object)new GridData(768));
        this.fRemoveRestriction.setLayoutData((Object)new GridData(768));
    }

    @Override
    public void updateFields(ISchemaObject object) {
        if (!(object instanceof SchemaAttribute)) {
            return;
        }
        super.updateFields(object);
        String basedOn = this.getAttribute().getBasedOn();
        if (basedOn != null && basedOn.length() > 0) {
            this.fReferenceEntry.setValue(basedOn, true);
        } else {
            this.fReferenceEntry.setValue("", true);
        }
        boolean editable = this.isEditableElement();
        this.fReferenceEntry.setEditable(editable);
        this.fRestrictionsTable.setInput(new Object());
        this.fRestrictionsTable.getControl().setEnabled(editable);
        this.fAddRestriction.setEnabled(editable);
        this.fRemoveRestriction.setEnabled(!this.fRestrictionsTable.getSelection().isEmpty() && editable);
    }

    @Override
    public void hookListeners() {
        super.hookListeners();
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fReferenceEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                if (SchemaIdentifierAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaIdentifierAttributeDetails.this.getAttribute().setBasedOn(SchemaIdentifierAttributeDetails.this.fReferenceEntry.getValue());
            }

            @Override
            public void browseButtonSelected(FormEntry entry) {
                if (SchemaIdentifierAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaIdentifierAttributeDetails.this.doOpenSelectionDialog(SchemaIdentifierAttributeDetails.this.fReferenceEntry);
            }
        });
        this.fAddRestriction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaIdentifierAttributeDetails.this.blockListeners()) {
                    return;
                }
                NewRestrictionDialog dialog = new NewRestrictionDialog(SchemaIdentifierAttributeDetails.this.getPage().getSite().getShell());
                if (dialog.open() != 0) {
                    return;
                }
                String text = dialog.getNewRestriction();
                if (text != null && text.length() > 0) {
                    ISchemaSimpleType type = SchemaIdentifierAttributeDetails.this.getAttribute().getType();
                    ChoiceRestriction res = (ChoiceRestriction)type.getRestriction();
                    Vector<Object> vres = new Vector<Object>();
                    if (res != null) {
                        ISchemaEnumeration[] currRes = res.getChildren();
                        int i = 0;
                        while (i < currRes.length) {
                            vres.add(currRes[i]);
                            ++i;
                        }
                    }
                    vres.add(new SchemaEnumeration((ISchemaObject)SchemaIdentifierAttributeDetails.this.getAttribute().getSchema(), text));
                    if (res == null) {
                        res = new ChoiceRestriction(SchemaIdentifierAttributeDetails.this.getAttribute().getSchema());
                    }
                    res.setChildren(vres);
                    if (type instanceof SchemaSimpleType) {
                        ((SchemaSimpleType)type).setRestriction((ISchemaRestriction)res);
                    }
                    SchemaIdentifierAttributeDetails.this.fRestrictionsTable.refresh();
                }
            }
        });
        this.fRemoveRestriction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaIdentifierAttributeDetails.this.blockListeners()) {
                    return;
                }
                ISelection selection = SchemaIdentifierAttributeDetails.this.fRestrictionsTable.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sselection = (IStructuredSelection)selection;
                Object[] aselection = sselection.toArray();
                ISchemaSimpleType type = SchemaIdentifierAttributeDetails.this.getAttribute().getType();
                ChoiceRestriction res = (ChoiceRestriction)type.getRestriction();
                Vector<ISchemaEnumeration> vres = new Vector<ISchemaEnumeration>();
                if (res != null) {
                    ISchemaEnumeration[] currRes = res.getChildren();
                    int i = 0;
                    while (i < currRes.length) {
                        boolean stays = true;
                        int j = 0;
                        while (j < aselection.length) {
                            if (currRes[i].equals(aselection[j])) {
                                stays = false;
                            }
                            ++j;
                        }
                        if (stays) {
                            vres.add(currRes[i]);
                        }
                        ++i;
                    }
                    res.setChildren(vres);
                    if (type instanceof SchemaSimpleType) {
                        if (vres.size() == 0) {
                            ((SchemaSimpleType)type).setRestriction(null);
                        } else {
                            ((SchemaSimpleType)type).setRestriction((ISchemaRestriction)res);
                        }
                    }
                    SchemaIdentifierAttributeDetails.this.fRestrictionsTable.refresh();
                }
            }
        });
        this.fRestrictionsTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SchemaIdentifierAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaIdentifierAttributeDetails.this.fRemoveRestriction.setEnabled(SchemaIdentifierAttributeDetails.this.getAttribute().getSchema().isEditable() && !event.getSelection().isEmpty());
            }
        });
    }

    private void doOpenSelectionDialog(FormEntry entry) {
        Object[] result;
        Object object;
        FilteredSchemaAttributeSelectionDialog dialog = new FilteredSchemaAttributeSelectionDialog(PDEPlugin.getActiveWorkbenchShell());
        int status = dialog.open();
        if (status == 0 && (object = (result = dialog.getResult())[0]) instanceof ISchemaAttribute) {
            ISchemaAttribute attribute = (ISchemaAttribute)object;
            String id = PDESchemaHelper.getReferenceIdentifier((ISchemaAttribute)attribute);
            entry.setValue(id);
            entry.commit();
        }
    }
}

