/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class QualifiedNameSearchResult {
    private Map<IFile, TextChange> fChanges = new HashMap<IFile, TextChange>();

    public TextChange getChange(IFile file) {
        TextChange result = this.fChanges.get(file);
        if (result == null) {
            result = new TextFileChange(file.getName(), file);
            this.fChanges.put(file, result);
        }
        return result;
    }

    public TextChange[] getAllChanges() {
        Collection<TextChange> values = this.fChanges.values();
        return values.toArray(new TextChange[values.size()]);
    }

    public IFile[] getAllFiles() {
        Set<IFile> keys = this.fChanges.keySet();
        return keys.toArray(new IFile[keys.size()]);
    }

    public Change getSingleChange(IFile[] alreadyTouchedFiles) {
        Collection<TextChange> values = this.fChanges.values();
        if (values.size() == 0) {
            return null;
        }
        CompositeChange result = new CompositeChange(RefactoringCoreMessages.QualifiedNameSearchResult_change_name);
        result.markAsSynthetic();
        List<IFile> files = Arrays.asList(alreadyTouchedFiles);
        for (TextFileChange textFileChange : values) {
            if (files.contains(textFileChange.getFile())) continue;
            result.add((Change)textFileChange);
        }
        return result;
    }
}

