/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.eclipse.pde.internal.core.text.IDocumentKey;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleClasspathHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.core.text.bundle.CompositeManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.ExecutionEnvironment;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PDEManifestElement;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.core.text.bundle.RequiredExecutionEnvironmentHeader;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.IFoldingStructureProvider;
import org.eclipse.pde.internal.ui.editor.KeyValueSourcePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.plugin.BundleFoldingStructureProvider;
import org.eclipse.pde.internal.ui.editor.plugin.BundleHyperlinkDetector;
import org.eclipse.pde.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.ManifestConfiguration;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.refactoring.PDERefactoringAction;
import org.eclipse.pde.internal.ui.refactoring.RefactoringActionFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.forms.editor.FormEditor;

public class BundleSourcePage
extends KeyValueSourcePage {
    private Object fTargetOutlineSelection;
    private int fCurrentHighlightRangeOffset;
    private final int F_NOT_SET = -1;
    private PDERefactoringAction fRenameAction;

    private IPluginLibrary[] getBundleClasspathLibraries() {
        PDEFormEditor formEditor;
        IBaseModel baseModel;
        FormEditor editor = this.getEditor();
        if (editor instanceof PDEFormEditor && (baseModel = (formEditor = (PDEFormEditor)editor).getAggregateModel()) instanceof IPluginModelBase) {
            IPluginLibrary[] libraries = ((IPluginModelBase)baseModel).getPluginBase().getLibraries();
            return libraries;
        }
        return null;
    }

    public BundleSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
        this.resetTargetOutlineSelection();
        this.resetCurrentHighlightRangeOffset();
    }

    private void setCurrentHighlightRangeOffset(int offset) {
        this.fCurrentHighlightRangeOffset = offset;
    }

    private void resetCurrentHighlightRangeOffset() {
        this.fCurrentHighlightRangeOffset = -1;
    }

    private int getCurrentHighlightRangeOffset() {
        return this.fCurrentHighlightRangeOffset;
    }

    public void resetHighlightRange() {
        this.resetCurrentHighlightRangeOffset();
        super.resetHighlightRange();
    }

    private void resetTargetOutlineSelection() {
        this.fTargetOutlineSelection = null;
    }

    private void setTargetOutlineSelection(Object object) {
        this.fTargetOutlineSelection = object;
    }

    private Object getTargetOutlineSelection() {
        return this.fTargetOutlineSelection;
    }

    @Override
    public ILabelProvider createOutlineLabelProvider() {
        return new BundleLabelProvider();
    }

    @Override
    public ITreeContentProvider createOutlineContentProvider() {
        return new BundleOutlineContentProvider();
    }

    @Override
    public IDocumentRange getRangeElement(int offset, boolean searchChildren) {
        IBundleModel model = (IBundleModel)this.getInputContext().getModel();
        Map manifest = ((Bundle)model.getBundle()).getHeaders();
        this.resetTargetOutlineSelection();
        for (IDocumentRange node : manifest.values()) {
            IDocumentRange child_node;
            if (!this.isWithinCurrentRange(offset, node)) continue;
            if (searchChildren && node instanceof CompositeManifestHeader && (child_node = this.getRangeElementChild(model, offset, (CompositeManifestHeader)node)) != null) {
                return child_node;
            }
            this.setTargetOutlineSelection(node);
            return node;
        }
        return null;
    }

    private boolean isWithinCurrentRange(int offset, IDocumentRange range) {
        if (range == null) {
            return false;
        }
        return offset >= range.getOffset() && offset <= range.getOffset() + range.getLength();
    }

    private boolean isWithinPreviousRange(int offset, IDocumentRange current_range, IDocumentRange previous_range) {
        if (current_range == null || previous_range == null) {
            return false;
        }
        return offset >= previous_range.getOffset() + previous_range.getLength() && offset <= current_range.getOffset();
    }

    private boolean isBeforePreviousRange(int offset, IDocumentRange previousRange) {
        if (previousRange == null) {
            return false;
        }
        return offset < previousRange.getOffset();
    }

    private IDocumentRange getRangeElementChild(IBundleModel model, int offset, CompositeManifestHeader header) {
        if (header.isEmpty()) {
            return null;
        }
        PDEManifestElement[] elements = header.getElements();
        String headerName = this.getHeaderName(elements[0]);
        PDEManifestElement previousElement = null;
        PDEManifestElement currentElement = null;
        IDocumentRange previousRange = null;
        IDocumentRange currentRange = null;
        int i = 0;
        while (i < elements.length) {
            currentElement = elements[i];
            currentRange = BundleSourcePage.getSpecificRange(model, headerName, currentElement.getValue());
            if (this.isBeforePreviousRange(offset, previousRange)) {
                return null;
            }
            if (this.isWithinCurrentRange(offset, currentRange)) {
                this.setChildTargetOutlineSelection(headerName, currentElement);
                return currentRange;
            }
            if (this.isWithinPreviousRange(offset, currentRange, previousRange)) {
                this.setChildTargetOutlineSelection(headerName, previousElement);
                return previousRange;
            }
            previousRange = currentRange;
            previousElement = currentElement;
            ++i;
        }
        if (this.isWithinLastElementParamRange(offset, currentRange, (IDocumentRange)header)) {
            this.setChildTargetOutlineSelection(headerName, currentElement);
            return currentRange;
        }
        return null;
    }

    private boolean isWithinLastElementParamRange(int offset, IDocumentRange currentRange, IDocumentRange headerRange) {
        if (currentRange == null) {
            return false;
        }
        return offset >= currentRange.getOffset() + currentRange.getLength() && offset <= headerRange.getOffset() + headerRange.getLength();
    }

    private void setChildTargetOutlineSelection(String headerName, PDEManifestElement element) {
        if (headerName.equalsIgnoreCase("Bundle-ClassPath")) {
            this.setTargetOutlineSelection(this.getBundleClasspathOutlineSelection(element));
        } else {
            this.setTargetOutlineSelection(element);
        }
    }

    private Object getBundleClasspathOutlineSelection(PDEManifestElement manifestElement) {
        IPluginLibrary[] libraries = this.getBundleClasspathLibraries();
        if (libraries == null || libraries.length == 0) {
            return null;
        }
        int i = 0;
        while (i < libraries.length) {
            if (manifestElement.getValue().equals(libraries[i].getName())) {
                return libraries[i];
            }
            ++i;
        }
        return null;
    }

    private String getHeaderName(PDEManifestElement element) {
        if (element instanceof ExportPackageObject) {
            return "Export-Package";
        }
        if (element instanceof ImportPackageObject) {
            return "Import-Package";
        }
        if (element instanceof ExecutionEnvironment) {
            return "Bundle-RequiredExecutionEnvironment";
        }
        if (element instanceof RequireBundleObject) {
            return "Require-Bundle";
        }
        return "Bundle-ClassPath";
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] ids = super.collectContextMenuPreferencePages();
        String[] more = new String[ids.length + 1];
        more[0] = "org.eclipse.pde.ui.EditorPreferencePage";
        System.arraycopy(ids, 0, more, 1, ids.length);
        return more;
    }

    @Override
    public IDocumentRange findRange() {
        Object selection = this.getSelection();
        if (selection instanceof ImportObject) {
            IPluginModelBase base = ((ImportObject)selection).getImport().getPluginModel();
            if (base instanceof IBundlePluginModelBase) {
                return BundleSourcePage.getSpecificRange(((IBundlePluginModelBase)base).getBundleModel(), "Require-Bundle", ((ImportObject)selection).getId());
            }
        } else {
            if (selection instanceof ImportPackageObject) {
                return BundleSourcePage.getSpecificRange(((ImportPackageObject)selection).getModel(), "Import-Package", ((ImportPackageObject)selection).getValue());
            }
            if (selection instanceof ExportPackageObject) {
                return BundleSourcePage.getSpecificRange(((ExportPackageObject)selection).getModel(), "Export-Package", ((ExportPackageObject)selection).getValue());
            }
            if (selection instanceof IPluginLibrary) {
                IPluginModelBase base = ((IPluginLibrary)selection).getPluginModel();
                if (base instanceof IBundlePluginModelBase) {
                    return BundleSourcePage.getSpecificRange(((IBundlePluginModelBase)base).getBundleModel(), "Bundle-ClassPath", ((IPluginLibrary)selection).getName());
                }
            } else {
                if (selection instanceof ExecutionEnvironment) {
                    return BundleSourcePage.getSpecificRange(((ExecutionEnvironment)selection).getModel(), "Bundle-RequiredExecutionEnvironment", ((ExecutionEnvironment)selection).getValue());
                }
                if (selection instanceof RequireBundleObject) {
                    return BundleSourcePage.getSpecificRange(((RequireBundleObject)selection).getModel(), "Require-Bundle", ((RequireBundleObject)selection).getId());
                }
            }
        }
        return null;
    }

    public static IDocumentRange getSpecificRange(IBundleModel model, IManifestHeader header, String element) {
        if (header == null || !(model instanceof IEditingModel)) {
            return null;
        }
        final int[] range = new int[]{-1, -1};
        try {
            int start = header.getOffset() + header.getName().length();
            int length = header.getLength() - header.getName().length();
            String headerValue = ((IEditingModel)model).getDocument().get(start, length);
            int i = headerValue.indexOf(element);
            int last = headerValue.lastIndexOf(element);
            if (i > 0 && i != last) {
                char[] sChar = element.toCharArray();
                char[] headerChar = headerValue.toCharArray();
                while (i <= last) {
                    block10: {
                        if (headerChar[i] == sChar[0] || headerChar[i + sChar.length / 2] == sChar[sChar.length / 2] || headerChar[i + sChar.length - 1] == sChar[sChar.length - 1]) {
                            int index;
                            int j = 1;
                            while (j < sChar.length - 1) {
                                if (headerChar[i + j] == sChar[j]) {
                                    ++j;
                                    continue;
                                }
                                break block10;
                            }
                            char c = headerChar[i - 1];
                            if (!(!Character.isWhitespace(c) && c != ',' || (index = i + sChar.length) >= headerChar.length || (c = headerChar[index]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && c != '.') break;
                        }
                    }
                    ++i;
                }
            }
            if (i != -1) {
                range[0] = start + i;
                range[1] = element.length();
            }
        }
        catch (BadLocationException badLocationException) {}
        if (range[0] == -1) {
            range[0] = header.getOffset();
            range[1] = header.getName().length();
        }
        return new IDocumentRange(){

            public int getOffset() {
                return range[0];
            }

            public int getLength() {
                return range[1];
            }
        };
    }

    public static IDocumentRange getSpecificRange(IBundleModel model, String headerName, String search) {
        IManifestHeader header = model.getBundle().getManifestHeader(headerName);
        return BundleSourcePage.getSpecificRange(model, header, search);
    }

    @Override
    protected boolean isSelectionListener() {
        return true;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IHyperlinkDetector.class.equals((Object)adapter)) {
            return new BundleHyperlinkDetector(this);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void updateSelection(Object object) {
        this.setSelectedObject(object);
        if (object instanceof IDocumentKey) {
            this.setHighlightRange((IDocumentKey)object);
            this.setCurrentHighlightRangeOffset(((IDocumentKey)object).getOffset());
            return;
        }
        IDocumentRange range = this.findRange();
        if (range == null) {
            return;
        }
        IBaseModel model = this.getInputContext().getModel();
        if (!(model instanceof AbstractEditingModel)) {
            return;
        }
        if (range.getOffset() == -1 || this.isDirty()) {
            try {
                ((AbstractEditingModel)model).adjustOffsets(((AbstractEditingModel)model).getDocument());
            }
            catch (CoreException coreException) {}
            range = this.findRange();
        }
        this.setCurrentHighlightRangeOffset(range.getOffset());
        this.setHighlightRange(range, true);
        this.setSelectedRange(range, false);
    }

    @Override
    protected void handleSelectionChangedSourcePage(SelectionChangedEvent event) {
        super.handleSelectionChangedSourcePage(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty() || !(selection instanceof ITextSelection)) {
            return;
        }
        IBaseModel model = this.getInputContext().getModel();
        if (model instanceof AbstractEditingModel && this.isDirty()) {
            try {
                ((AbstractEditingModel)model).adjustOffsets(((AbstractEditingModel)model).getDocument());
            }
            catch (CoreException coreException) {}
        }
        this.synchronizeOutlinePage(((ITextSelection)selection).getOffset());
    }

    @Override
    protected void synchronizeOutlinePage(int offset) {
        int previous_offset = this.getCurrentHighlightRangeOffset();
        if (previous_offset == offset) {
            return;
        }
        IDocumentRange rangeElement = this.getRangeElement(offset, true);
        this.updateHighlightRange(rangeElement);
        this.updateOutlinePageSelection(this.getTargetOutlineSelection());
    }

    @Override
    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        IBaseModel base;
        super.editorContextMenuAboutToShow(menu);
        StyledText text = this.getViewer().getTextWidget();
        Point p = text.getSelection();
        IDocumentRange element = this.getRangeElement(p.x, false);
        if (!(element instanceof BundleSymbolicNameHeader) || !((BundleSymbolicNameHeader)element).getModel().isEditable()) {
            return;
        }
        if (this.fRenameAction == null && (base = ((PDEFormEditor)this.getEditor()).getAggregateModel()) instanceof IPluginModelBase) {
            this.fRenameAction = RefactoringActionFactory.createRefactorPluginIdAction(NLS.bind((String)PDEUIMessages.BundleSourcePage_renameActionText, (Object)"Bundle-SymbolicName"));
            this.fRenameAction.setSelection(base);
        }
        if (this.fRenameAction != null) {
            menu.insertAfter("org.eclipse.pde.ui.quickOutline", (IAction)this.fRenameAction);
        }
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.updateTextSelection();
        }
    }

    @Override
    protected IFoldingStructureProvider getFoldingStructureProvider(IEditingModel model) {
        return new BundleFoldingStructureProvider(this, model);
    }

    @Override
    protected ChangeAwareSourceViewerConfiguration createSourceViewerConfiguration(IColorManager colorManager) {
        return new ManifestConfiguration(colorManager, this);
    }

    private class BundleLabelProvider
    extends LabelProvider {
        private BundleLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof PackageObject) {
                return ((PackageObject)obj).getName();
            }
            if (obj instanceof ExecutionEnvironment) {
                return ((ExecutionEnvironment)obj).getName();
            }
            if (obj instanceof RequireBundleObject) {
                return this.getTextRequireBundle((RequireBundleObject)obj);
            }
            if (obj instanceof ManifestHeader) {
                return ((ManifestHeader)obj).getName();
            }
            return super.getText(obj);
        }

        private String getTextRequireBundle(RequireBundleObject bundle) {
            StringBuffer label = new StringBuffer();
            label.append(bundle.getId());
            String version = bundle.getVersion();
            if (version == null || version.length() == 0) {
                return label.toString();
            }
            label.append(' ');
            char firstChar = version.charAt(0);
            if (firstChar != '(' && firstChar != '[') {
                label.append('(');
            }
            label.append(version);
            char lastChar = version.charAt(version.length() - 1);
            if (lastChar != ')' && lastChar != ']') {
                label.append(')');
            }
            return label.toString();
        }

        public Image getImage(Object obj) {
            PDELabelProvider labelProvider = PDEPlugin.getDefault().getLabelProvider();
            if (obj instanceof PackageObject) {
                return labelProvider.get(PDEPluginImages.DESC_PACKAGE_OBJ);
            }
            if (obj instanceof ExecutionEnvironment) {
                return labelProvider.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
            }
            if (obj instanceof RequireBundleObject) {
                int flags = 32;
                if (((RequireBundleObject)obj).isReexported()) {
                    flags |= 4;
                }
                return labelProvider.get(PDEPluginImages.DESC_REQ_PLUGIN_OBJ, flags);
            }
            if (obj instanceof ManifestHeader) {
                return labelProvider.get(PDEPluginImages.DESC_BUILD_VAR_OBJ);
            }
            if (obj instanceof IPluginLibrary) {
                return labelProvider.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
            }
            return null;
        }
    }

    private class BundleOutlineContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        private BundleOutlineContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ImportPackageHeader) {
                return ((ImportPackageHeader)parent).getPackages();
            }
            if (parent instanceof ExportPackageHeader) {
                return ((ExportPackageHeader)parent).getPackages();
            }
            if (parent instanceof RequiredExecutionEnvironmentHeader) {
                return ((RequiredExecutionEnvironmentHeader)parent).getEnvironments();
            }
            if (parent instanceof RequireBundleHeader) {
                return ((RequireBundleHeader)parent).getRequiredBundles();
            }
            if (parent instanceof BundleClasspathHeader) {
                return this.getPluginLibraries();
            }
            return new Object[0];
        }

        private Object[] getPluginLibraries() {
            Object[] libraries = BundleSourcePage.this.getBundleClasspathLibraries();
            if (libraries == null || libraries.length == 0) {
                return new Object[0];
            }
            return libraries;
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof BundleModel) {
                BundleModel model = (BundleModel)parent;
                Map manifest = ((Bundle)model.getBundle()).getHeaders();
                ArrayList<IDocumentKey> keys = new ArrayList<IDocumentKey>();
                Iterator elements = manifest.keySet().iterator();
                while (elements.hasNext()) {
                    IDocumentKey key = (IDocumentKey)manifest.get(elements.next());
                    if (key.getOffset() <= -1) continue;
                    keys.add(key);
                }
                return keys.toArray();
            }
            return new Object[0];
        }
    }
}

