/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.formatter;

public class EclFormatterOptions {
    public boolean useTabs = true;
    public int tabSize = 4;
    public int wrapAt = 80;
    public int indent = 4;
    public int wrapIndent = 8;
    public int minLiteralLengthToWrap = 7;
    public int minLiteralLengthToStayOnWrap = 10;

    public EclFormatterOptions useTabs(boolean on) {
        this.useTabs = on;
        return this;
    }

    public EclFormatterOptions tabSize(int spaces) {
        if (spaces < 0) {
            throw new IllegalArgumentException("spaces must be non-negative.");
        }
        this.tabSize = spaces;
        return this;
    }

    public EclFormatterOptions wrapAt(int column) {
        if (column <= 0) {
            throw new IllegalArgumentException("column must be greater than 0.");
        }
        this.wrapAt = column;
        return this;
    }

    public EclFormatterOptions indent(int spaces) {
        if (spaces < 0) {
            throw new IllegalArgumentException("spaces must be non-negative.");
        }
        this.indent = spaces;
        return this;
    }

    public EclFormatterOptions wrapIndent(int spaces) {
        if (spaces < 0) {
            throw new IllegalArgumentException("spaces must be non-negative.");
        }
        this.wrapIndent = spaces;
        return this;
    }
}

