/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.help.internal.search.SearchHit;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteSearchParser
extends DefaultHandler {
    private SAXParser parser;
    private Stack<SearchHit> stack;
    private List<SearchHit> hits;
    private StringBuffer summary;

    public List<SearchHit> parse(InputStream in, IProgressMonitor monitor) throws ParserConfigurationException, SAXException, IOException {
        monitor.beginTask("", 1);
        this.init();
        this.parser.parse(in, (DefaultHandler)this);
        monitor.worked(1);
        monitor.done();
        return this.hits;
    }

    private void init() throws ParserConfigurationException, SAXException {
        if (this.hits == null) {
            this.hits = new ArrayList<SearchHit>();
        } else if (!this.hits.isEmpty()) {
            this.hits.clear();
        }
        if (this.stack == null) {
            this.stack = new Stack();
        } else if (!this.stack.isEmpty()) {
            this.stack.clear();
        }
        this.summary = null;
        if (this.parser == null) {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("hit")) {
            this.handleHit(attributes);
        } else if (qName.equals("summary")) {
            this.handleSummary(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("hit")) {
            this.stack.pop();
        } else if (qName.equals("summary") && this.summary != null) {
            SearchHit hit = this.stack.peek();
            hit.setSummary(this.summary.toString());
            this.summary = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.summary != null) {
            this.summary.append(ch, start, length);
        }
    }

    private void handleHit(Attributes attr) {
        float score;
        String href = attr.getValue("href");
        String label = attr.getValue("label");
        boolean isPotentialHit = String.valueOf(true).equalsIgnoreCase(attr.getValue("isPotentialHit"));
        try {
            score = Float.parseFloat(attr.getValue("score"));
        }
        catch (NumberFormatException numberFormatException) {
            score = 0.0f;
        }
        SearchHit hit = new SearchHit(href, label, null, score, null, null, null, isPotentialHit);
        this.hits.add(hit);
        this.stack.push(hit);
    }

    private void handleSummary(Attributes attr) {
        this.summary = new StringBuffer();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new StringReader(""));
    }
}

