/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.problems;

import org.eclipse.core.runtime.Assert;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;

public class ApiProblemFilter
implements IApiProblemFilter,
Cloneable {
    public static final String HANDLE_ARGUMENTS_DELIMITER = ",";
    public static final String HANDLE_DELIMITER = "%]";
    private String fComponentId = null;
    private IApiProblem fProblem = null;
    private String fComment = null;

    public ApiProblemFilter(String componentid, IApiProblem problem, String comment) {
        this.fComponentId = componentid;
        Assert.isNotNull((Object)problem);
        this.fProblem = problem;
        this.fComment = comment;
    }

    @Override
    public String getComment() {
        return this.fComment;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    @Override
    public String getComponentId() {
        return this.fComponentId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiProblemFilter) {
            IApiProblemFilter filter = (IApiProblemFilter)obj;
            return this.elementsEqual(filter.getComponentId(), this.fComponentId) && filter.getUnderlyingProblem().equals(this.fProblem);
        }
        if (obj instanceof IApiProblem) {
            return this.fProblem.equals(obj);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.fProblem.hashCode() + this.fComponentId.hashCode();
    }

    private boolean elementsEqual(Object s1, Object s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Filter for : ");
        buffer.append(this.fProblem.toString());
        return buffer.toString();
    }

    public Object clone() {
        return new ApiProblemFilter(this.fComponentId, this.fProblem, this.fComment);
    }

    @Override
    public IApiProblem getUnderlyingProblem() {
        return this.fProblem;
    }

    public String getHandle() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fProblem.getId());
        buffer.append(HANDLE_DELIMITER);
        buffer.append(this.fProblem.getResourcePath());
        buffer.append(HANDLE_DELIMITER);
        buffer.append(this.fProblem.getTypeName());
        buffer.append(HANDLE_DELIMITER);
        String[] margs = this.fProblem.getMessageArguments();
        int i = 0;
        while (i < margs.length) {
            buffer.append(margs[i]);
            if (i < margs.length - 1) {
                buffer.append(HANDLE_ARGUMENTS_DELIMITER);
            }
            ++i;
        }
        return buffer.toString();
    }
}

